<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
class Admin extends CI_Controller
{
  private $dataNilai;
  private $dataPrestasi;
  private $dataAfirmasi;
  public function __construct()
  {
    parent::__construct();
    $this->load->model('Ppdb_model', 'daftar');
    $this->load->model('Admin_model', 'item_m');

    is_logged_in();
  }
  public function index()
  {
    $data['title'] = 'Dashboard';
    $data['prestasi'] = $this->db->get('kategori_penyelengara')->result_array();
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    $data['jalur'] = $this->db->get_where('jalur_ppdb', ['statusAktif' => 1])->result_array();
    $data['daftar'] = $this->db->get('register')->num_rows();
    $belumSubmit = $this->daftar->getJumlahDaftar(1);
    $data['belumSubmit'] = $belumSubmit;
    $data['proses'] = $this->daftar->getJumlahDaftar(2);
    $data['verifikasi'] = $this->daftar->getJumlahDaftar(3);
    $data['mundur'] = $this->daftar->getJumlahDaftar(4);
    $data['terima'] = $this->daftar->getJumlahDaftar(5);
    $data['tidakDiterima'] = $this->daftar->getJumlahDaftar(5);
    $data['pekerjaan'] = $this->db->get('pekerjaan')->result_array();
    $data['pendidikan'] = $this->db->get('pendididikan')->result_array();
    $data['penghasilan'] = $this->db->get('penghasilan')->result_array();
    $data['kategori']=$this->db->get('kat_satuan')->result_array();
    $data['rank'] = $this->db->get('rangking_skor')->result_array();
    $data['jenis_afirmasi'] = $this->db->get('jenis_afirmasi')->result_array();
    $data['prestasi'] = $this->db->get('prestasi')->result_array();
    $data['penyelengara'] = $this->db->get('kategori_penyelengara')->result_array();
    // $data['kota'] = $this->db->get('regencies')->result_array();
    $data['provinsi'] = $this->db->get('provinces')->result_array();
    // $data['kecamatan'] = $this->db->get('districts')->result_array();
    // $data['desa'] = $this->db->get('villages')->result_array();
    $this->load->view('themplate/admin/header', $data);
    $this->load->view('themplate/admin/sidebar', $data);
    $this->load->view('themplate/admin/topbar', $data);
    $this->load->view('Admin/index', $data);
    // $this->load->view('themplate/Akun/footermaps', $data);
    $this->load->view('themplate/admin/footer', $data);

  }

  public function getDataJalurUntukLoadJalurPpdbDiVerifikasi(){
    echo json_encode($this->db->get('jalur_ppdb')->result_array());
  }

  public function saveVrifikasiJalur(){
    if (isset($_POST['jalurPpdb'])){
      // $this->load->model('Register21', 'register');
      $jalur = $this->daftar->getDataJalur($_POST['jalurPpdb']);
      if($jalur['input_nilai']==1){
        // prepare data sesuai syarat khusus
        $dataNilai=MyFilter::fPostRaport($_POST);
        $this->dataNilai=$dataNilai;
      }

      if($jalur['inputPrestasi']==1){
        // iput prestasi di perlukan
           $dataPrestasi=MyFilter::fPostKejuaraan($_POST);
           $this->dataPrestasi=$dataPrestasi;
          
      }

      if($jalur['input_afirmasi']==1){
        // iput prestasi di perlukan
        $dataAfirmasi=MyFilter::fPostAfirmasi($_POST);
        $this->dataAfirmasi = $dataAfirmasi;
        }
        
        
        $result= $this->daftar->simpanDataVerifikasi($this->dataAfirmasi,$this->dataPrestasi,$this->dataNilai,$jalur,$_POST['id_pendaftar']);
        if($result['pesan'] == true){
        $message = [
        'pesan'=>'ok',
        'koreg'=>$result['koreg']
        ];
          echo json_encode($message);
        }else{
          $message = [
            'pesan'=>'error',
            ];
          echo json_encode($message);
        }
          
      }else{
        // gagal Simpan
        $message=['pesan'=>'error'];
        echo json_encode($message);
          
      }

   
  }

  public function changejalur(){

    echo json_encode($this->item_m->getDataJalur($_POST['id']));
 
   }

  public function loadDataRaportByPendaftar(){
    if(isset($_POST['id'])){
            // ambil data raport nya
      echo json_encode($this->item_m->getDataRaportByid($_POST['id']));
    }
}


  public function verifiksai()
  {
    $data['title'] = 'SuksesVerifikasi';
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    // echo json_encode($_POST);die;
    $callback = $this->item_m->simpanVerifikasi($_POST);
    $pendaftar = $this->db->get_where('register', ['id' => $callback['kode']])->row_array();
    if ($callback['affect'] > 0) {
      $pesan['koreg'] = $_POST['koregSen'];
      $pesan['id'] = $_POST['id'];
      $pesan['statusDaftar'] = $pendaftar['statusDaftar'];
      $pesan['pesan'] = 'berhasil';
      echo json_encode($pesan);
    } else {
      // $pendaftar = $this->db->get_where('register', ['koreg' => $_POST['koregSen']])->row_array();
      $pesan['statusDaftar'] = $pendaftar['statusDaftar'];
      $pesan['koreg'] = $_POST['koregSen'];
      $pesan['id'] = $_POST['id'];
      $pesan['pesan'] = false;
      echo json_encode($pesan);
    }
    // echo json_encode($_POST);
    // $data['pendaftar'] = $this->db->get_where('pendaftar', ['koreg' => $koreg])->row_array();
    // $this->load->view('themplate/admin/header', $data);
    // $this->load->view('themplate/admin/sidebar', $data);
    // $this->load->view('themplate/admin/topbar', $data);
    // $this->load->view('Admin/SuksesVerifikasi', $data);
    // $this->load->view('themplate/admin/footer', $data);
  }

  // statistik

  // 2023
  // get data verifikasi
  public function getDataVerifikasi(){
    if(isset($_POST)){
      echo json_encode($this->daftar->getDataVerifikasi($_POST));
    }
  }

  public function SimpanAlamatVerifikasi(){
    if($this->daftar->SimpanAlamatVerifikasi($_POST)>0){

      echo json_encode(['pesan'=>'ok']);
    }else{
      echo json_encode(['pesan'=>'error']);

    }
  }

  public function SimpanBiodataVerifikasi(){
    if($this->daftar->SimpanBiodataVerifikasi($_POST)>0){

      echo json_encode(['pesan'=>'ok']);
    }else{
      echo json_encode(['pesan'=>'error']);

    }
  }



  public function statistik()
  {

    $data['daftar'] = $this->db->get('register')->num_rows();
    $data['belumSubmit'] = $this->daftar->getJumlahDaftar(1);
    $data['proses'] = $this->daftar->getJumlahDaftar(2);
    $data['verifikasi'] = $this->daftar->getJumlahDaftar(3);
    $data['mundur'] = $this->daftar->getJumlahDaftar(4);
    echo json_encode($data);
  }

  public function CekNisn(){
    if(isset($_POST['nisnsiswa'])){
      $nisn = $_POST['nisnsiswa'] ? $_POST['nisnsiswa'] : false;
      $cek =  $this->item_m->cekEmailOrNISN('nisn', $nisn);
        if($cek > 0){
            echo "false";
        }else{
            echo "true";
        }
    }else{
      redirect('Admin');
    }
   
      
   }

   public function CekEmail(){
    if($_POST['email']){

      $email = $_POST['email'] ? $_POST['email'] : false;
      $cek = $this->item_m->cekEmailOrNISN('email', $email);
      if($cek > 0){
          echo "false";
      }else{
          echo "true";
      }
     
    }else{
      redirect('Admin');
    }

     
   }

  public function getDataPrestasiById()
  {
    echo json_encode($this->db->get_where('prestasi', ['id' => $_POST['id']])->row_array());
  }

  public function EditMinusNilaiPraktek()
  {
    echo json_encode($this->item_m->editNilaiPraktekByTombol($_POST));
  }

  public function EditMinusNilaiPraktekPlus()
  {
    echo json_encode($this->item_m->proseseditNilaiPraktekByTombolPlus($_POST));
  }

  function get_ajax()
  {
    $list = $this->item_m->get_datatables();
    // var_dump($list);
    // die;
    $data = array();
    $no = @$_POST['start'];
    foreach ($list as $item) {
      $no++;
      $row = array();
      $row[] = $no . ".";
      $row[] = $item->koreg;
      $row[] = $item->nama;
      $row[] = $item->namaJalur;
      $row[] = '<button data-koreg="' . $item->koreg . '" data-id="' . $item->id . '" data-target=".bd-example-modal-lg" class="badge badge-primary btnGetDataVerifikasi"><i class="fa fa-pencil"></i> Lihat</button> 
                <a href="' . base_url('Admin/PrintBuktiRegistrasi2/') . $item->koreg . '" target="_Blank" class="badge badge-secondary"><i class="fa fa-print" aria-hidden="true"></i> Cetak</a>
                <a href="' . base_url('Admin/hapusPendaftar/') . $item->id . '" class="badge badge-danger tombolHapus"><i class="fa fa-print" aria-hidden="true"></i> Hapus</a>';
      $data[] = $row;
    }
    $output = array(
      "draw" => @$_POST['draw'],
      "recordsTotal" => $this->item_m->count_all(),
      "recordsFiltered" => $this->item_m->count_filtered(),
      "data" => $data,
    );
    // output to json format

    echo json_encode($output);
  }

  // cek email operator
  public function cekEmaiOperator(){
     echo json_encode($this->db->get_where('user', ['email' => $_POST['email']])->num_rows());
    
  }

  public function hapusPendaftar($id)
  {
    $user = $this->db->get_where('register', ['id' => $id])->row_array();
    if ($user['id_jalur'] == 4) {
      $this->db->delete('kejuaraansiswa', ['id_pendaftar' => $id]);
    } else if ($user['id_jalur'] == 2) {
      $this->db->delete('afirmasi', ['id_pendaftar' => $id]);
    }
    $this->db->delete('nilai', ['id_pendaftar' => $id]);
    $this->db->delete('register', ['id' => $id]);
    if ($this->db->affected_rows() > 0) {
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Pendaftar ' . $user['namaSiswa'] . ' berhasil di Hapus!!
      </div>');
      redirect('Admin');
    } else {
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
     Data Pendaftar ' . $user['namaSiswa'] . ' Gagal di Hapus!!
      </div>');
      redirect('Admin');
    }
  }

  public function getDataPendaftarById()
  {
    echo json_encode($this->item_m->getDaftarById($_POST));
    // echo json_encode($_POST);
  }

  public function getDataPrestasiByIdDaftar()
  {
    $id = $_POST['id'];
    echo json_encode($this->item_m->getDataPrestasiByIdPendaftar($id));
  }


  // laporan All
  public function LaporanALL()
  {
    $data['sekolah'] = $this->db->get('kop_surat')->row_array();
    $sekolah = $data['sekolah']['nama_sekolah'];
    $data['pendaftar'] = $this->daftar->getDataPendaftar();
    $data['tanggal'] = $this->daftar->tanggal_indonesia(date('Y-m-d', strtotime($data['sekolah']['tanggalKelulusan'])));
    $alamat = $data['sekolah']['alamat'];
    $mpdf = new \Mpdf\Mpdf([
      'format' => 'Legal-P',
      'margin_left' => 20,
      'margin_right' => 20,
      'margin_top' => 60,
      'margin_bottom' => 30,
      'margin_header' => 10,
      'margin_footer' => 10,
    ]);
    $html = $this->load->view('Admin/PrintAll', $data, true);
    $html2 = $this->load->view('Admin/headerForm2', $data, true);
    $mpdf->SetHTMLHeader($html2);
    $mpdf->WriteHTML($html);
    $mpdf->SetHTMLFooter('
<table width="100%">
    <tr>
        <td width="33%" style="font-size:10px;">{DATE j-m-Y}</td>
        <td width="33%" align="center" style="font-size:10px;">{PAGENO}/{nbpg}</td>
        <td width="33%" style="text-align: right; font-size:10px;">' . $sekolah  . '</td>
    </tr>
</table>');
    $mpdf->Output();
  }

  // laporan form 3

  public function form3()
  {
    $data['sekolah'] = $this->db->get('kop_surat')->row_array();
    // $data['rangking'] = $this->daftar->rangkingPendaftar();
    // $data['jumlah'] = $this->daftar->getJumlahDataJalur();
    // var_dump($data['rangking']);
    // die;
    $data['tanggal'] = $this->daftar->tanggal_indonesia(date('Y-m-d', strtotime($data['sekolah']['tanggalKelulusan'])));
    $sekolah = $data['sekolah']['nama_sekolah'];
    $data['pendaftar'] = $this->daftar->getDataPendaftarDiterima();
    $alamat = $data['sekolah']['alamat'];
    $mpdf = new \Mpdf\Mpdf([
      'format' => 'Legal-P',
      'margin_left' => 20,
      'margin_right' => 20,
      'margin_top' => 60,
      'margin_bottom' => 30,
      'margin_header' => 10,
      'margin_footer' => 10,
    ]);
    $html = $this->load->view('Admin/printform3', $data, true);
    $html2 = $this->load->view('Admin/headerForm3', $data, true);
    $mpdf->SetHTMLHeader($html2);
    $mpdf->WriteHTML($html);
    $mpdf->SetHTMLFooter('
    <table width="100%">
        <tr>
            <td width="33%" style="font-size:10px;">{DATE j-m-Y}</td>
            <td width="33%" align="center" style="font-size:10px;">{PAGENO}/{nbpg}</td>
            <td width="33%" style="text-align: right; font-size:10px;">' . $sekolah  . '</td>
        </tr>
    </table>');
    $mpdf->Output();
  }


  public function cetakBuktiVerifikasi($id)
  {
    $this->load->model('Pendaftar_m','operator');
    $data= $this->operator->getdataprintByjalur($id);
    $mpdf = new \Mpdf\Mpdf([
      'format' => 'A4-L',
      'margin_left' => 20,
      'margin_right' => 10,
      'margin_top' => 12,
      'margin_bottom' => 0,
      'margin_header' => 0,
      'margin_footer' => 5,
      'debub'=>true
    ]);
    $html = $this->load->view('Admin/PrintVerifikasi', $data, true);
    $mpdf->WriteHTML($html);
    $mpdf->SetHTMLFooter('
<table width="100%">
    <tr>
        <td width="33%" style="font-size:9px;">{DATE j-m-Y}</td>
        <td width="33%" align="center" style="font-size:8px;">{PAGENO}/{nbpg}</td>
        <td width="33%" style="text-align: right; font-size:8px;">' . $data['dataSekolah']['nama_sekolah'] . '</td>
    </tr>
</table>');
    $mpdf->Output();
  }

  public function RisetVerif($id){
    $data=[
      'statusDaftar'=>2
    ];
    $this->db->set($data);
    $this->db->where(['id' => $id]);
    $this->db->update('register');
    if($this->db->affected_rows()>0){
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Peserta Berhasil Di Reset
     </div>');
      redirect('Admin');
    }else{
      redirect('Pendaftar');

    }
  }

  public function CabutBerkas($id){
    $data=[
      'statusDaftar'=>4
    ];
    $this->db->set($data);
    $this->db->where(['id' => $id]);
    $this->db->update('register');
    if($this->db->affected_rows()>0){
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Peserta Berhasil Di Keluarkan
     </div>');
      redirect('Admin');
    }else{
      redirect('Pendaftar');

    }

  }

  public function resetPerbaikan($id){
    $data=[
      'statusDaftar'=>1
    ];
    $this->db->set($data);
    $this->db->where(['id' => $id]);
    $this->db->update('register');
    if($this->db->affected_rows()>0){
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Peserta Berhasil Di Reset
     </div>');
      redirect('Pendaftar/Nonsubmit');
    }else{
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
     Data Peserta Gagal Di Reset
     </div>');
      redirect('Pendaftar/Nonsubmit');

    }
  }


  public function cetakKelulusan()
  {
    $data['sekolah'] = $this->db->get('kop_surat')->row_array();
    // var_dump($data['rangking']);
    // die;
    $sekolah = $data['sekolah']['nama_sekolah'];
    $logo = $data['sekolah']['logo'];
    $data['daftar'] = $this->daftar->getDataLulus();
    $data['tanggalSurat'] = $this->daftar->tanggal_indonesia(date('Y-m-d', strtotime($data['sekolah']['tanggalKelulusan'])));
    $alamat = $data['sekolah']['alamat'];
    $mpdf = new \Mpdf\Mpdf([
      'format' => 'A4-P',
      'margin_left' => 20,
      'margin_right' => 20,
      'margin_top' => 16,
      'margin_bottom' => 0,
      'margin_header' => 0,
      'margin_footer' => 4,
    ]);
    // ini_set('max_execution_time', '3000');
    // ini_set("pcre.backtrack_limit", "5000000");
    $htmlheader = $this->load->view('Admin/footerPrint', $data, true);
    $html = $this->load->view('Admin/printLulus', $data, true);
    $mpdf->SetHTMLHeader($htmlheader);
    $mpdf->WriteHTML($html);
    $mpdf->Output();
  }

  public function cetakTidakLulus()
  {
    $data['sekolah'] = $this->db->get('kop_surat')->row_array();
    // var_dump($data['rangking']);
    // die;
    $sekolah = $data['sekolah']['nama_sekolah'];
    $logo = $data['sekolah']['logo'];
    $data['daftar'] = $this->daftar->getDataTidakLulus();
    $data['tanggalSurat'] = $this->daftar->tanggal_indonesia(date('Y-m-d', strtotime($data['sekolah']['tanggalKelulusan'])));
    $alamat = $data['sekolah']['alamat'];
    $mpdf = new \Mpdf\Mpdf([
      'format' => 'A4-P',
      'margin_left' => 20,
      'margin_right' => 20,
      'margin_top' => 16,
      'margin_bottom' => 0,
      'margin_header' => 0,
      'margin_footer' => 4,
    ]);
    // ini_set('max_execution_time', '3000');
    // ini_set("pcre.backtrack_limit", "5000000");
    $htmlheader = $this->load->view('Admin/footerPrint', $data, true);
    $html = $this->load->view('Admin/printTidakLulus', $data, true);
    $mpdf->SetHTMLHeader($htmlheader);
    $mpdf->WriteHTML($html);
    $mpdf->SetHTMLFooter('
    <table width="100%">
        <tr>
            <td width="33%" style="font-size:9px;">{DATE j-m-Y}</td>
            <td width="33%" align="center" style="font-size:8px;">{PAGENO}/{nbpg}</td>
            <td width="33%" style="text-align: right; font-size:8px;">' . $sekolah  . '</td>
        </tr>
    </table>');
    $mpdf->Output();
  }

  public function formatA1()
  {
    $data['sekolah'] = $this->db->get('kop_surat')->row_array();
    $sekolah = $data['sekolah']['nama_sekolah'];
    $data['statistikLaporanA1'] = $this->daftar->statistikLaporanA1();
    // var_dump(($data['statistikLaporanA1']));
    // die;
    $data['tanggal'] = $this->daftar->tanggal_indonesia(date('Y-m-d', strtotime($data['sekolah']['tanggalKelulusan'])));

    $mpdf = new \Mpdf\Mpdf([
      'format' => 'legal-L',
      'margin_left' => 20,
      'margin_right' => 20,
      'margin_top' => 65,
      'margin_bottom' => 0,
      'margin_header' => 8,
      'margin_footer' => 10,
    ]);
    $htmlheader = $this->load->view('Admin/footerA1', $data, true);
    // $htmlheader2 = $this->load->view('Admin/footerA1', $data, true);
    $html = $this->load->view('Admin/printA1', $data, true);
    // $html2 = $this->load->view('Admin/printA12', $data, true);
    $mpdf->SetHTMLHeader($htmlheader);
    $mpdf->WriteHTML($html);
    // $mpdf->AddPage();
    // $mpdf->SetHTMLHeader($htmlheader2); 
    // $mpdf->WriteHTML($html2);
    $mpdf->SetHTMLFooter('
<table width="100%">
    <tr>
        <td width="33%" style="font-size:9px;">{DATE j-m-Y}</td>
        <td width="33%" align="center" style="font-size:8px;">{PAGENO}/{nbpg}</td>
        <td width="33%" style="text-align: right; font-size:8px;">' . $sekolah  . '</td>
    </tr>
</table>');
    $mpdf->Output();
  }


  // exsport data excel
  public function ExsporExcelByJalur($jalur)
  {
    $data['pendaftar'] = $this->daftar->getDataForExcel($jalur);
    $cekJalur = CekData::getInfoJalur($jalur);
    // var_dump($data['pendaftar']);
    // die;
    $object = new Spreadsheet();
    $object->getProperties()->setCreator('Data PPDB');
    $object->getProperties()->setLastModifiedBy('Data PPDB');
    $object->getProperties()->setTitle('Data Pendaftar');
    $object->setActiveSheetIndex(0);
    $object->getActiveSheet()->setCellValue('A1', 'No');
    $object->getActiveSheet()->setCellValue('B1', 'No Urut Daftar');
    $object->getActiveSheet()->setCellValue('C1', 'id');
    $object->getActiveSheet()->setCellValue('D1', 'Nama Calon Peserta Didik');
    $object->getActiveSheet()->setCellValue('E1', 'JK');
    $object->getActiveSheet()->setCellValue('F1', 'Tempat Lahir');
    $object->getActiveSheet()->setCellValue('G1', 'Tanggal Lahir');
    $object->getActiveSheet()->setCellValue('H1', 'USIA');
    $object->getActiveSheet()->setCellValue('I1', 'NIK');
    $object->getActiveSheet()->setCellValue('J1', 'NO KK');
    $object->getActiveSheet()->setCellValue('K1', 'NISN');
    $object->getActiveSheet()->setCellValue('L1', 'NO HP');
    $object->getActiveSheet()->setCellValue('M1', 'TINGGI BADAN');
    $object->getActiveSheet()->setCellValue('N1', 'BERAT BADAN');
    $object->getActiveSheet()->setCellValue('O1', 'AGAMA');
    $object->getActiveSheet()->setCellValue('P1', 'Asal Sekolah');
    $object->getActiveSheet()->setCellValue('Q1', 'NPSN SEKOLAH');
    $object->getActiveSheet()->setCellValue('R1', 'Jalur');
    $object->getActiveSheet()->setCellValue('S1', 'ALAMAT');
    $object->getActiveSheet()->setCellValue('T1', 'RT');
    $object->getActiveSheet()->setCellValue('U1', 'RW');
    $object->getActiveSheet()->setCellValue('V1', 'Desa');
    $object->getActiveSheet()->setCellValue('W1', 'Kecamatan');
    $object->getActiveSheet()->setCellValue('X1', 'Kota');
    $object->getActiveSheet()->setCellValue('Y1', 'Provinsi');
    $object->getActiveSheet()->setCellValue('Z1', 'KODE POS');
    $object->getActiveSheet()->setCellValue('AA1', 'LONGITUD');
    $object->getActiveSheet()->setCellValue('AB1', 'NAMA AYAH');
    $object->getActiveSheet()->setCellValue('AC1', 'NIK AYAH');
    $object->getActiveSheet()->setCellValue('AD1', 'TAHUN LAHIR  AYAH');
    $object->getActiveSheet()->setCellValue('AE1', 'PENDIDIKAN  AYAH');
    $object->getActiveSheet()->setCellValue('AF1', 'PEKERJAAN  AYAH');
    $object->getActiveSheet()->setCellValue('AG1', 'PENGHASILAN AYAH  AYAH');
    $object->getActiveSheet()->setCellValue('AH1', 'NAMA IBU');
    $object->getActiveSheet()->setCellValue('AI1', 'NIK IBU');
    $object->getActiveSheet()->setCellValue('AJ1', 'TAHUN LAHIR  IBU');
    $object->getActiveSheet()->setCellValue('AK1', 'PENDIDIKAN  IBU');
    $object->getActiveSheet()->setCellValue('AL1', 'PEKERJAAN  IBU');
    $object->getActiveSheet()->setCellValue('AM1', 'PENGHASILAN IBU  IBU');
    $object->getActiveSheet()->setCellValue('AN1', 'anak-ke');
    if (
      $jalur == 4
    ) {
      $object->getActiveSheet()->setCellValue('AO1', 'Nama Kejuaraan');
      $object->getActiveSheet()->setCellValue('AP1', 'Penyelengara');
      $object->getActiveSheet()->setCellValue('AQ1', 'Tingkat');
      $object->getActiveSheet()->setCellValue('AR1', 'Kategori');
      $object->getActiveSheet()->setCellValue('AS1', 'Skor Kejuaraan');
      $object->getActiveSheet()->setCellValue('AT1', 'Skor Uji Keterampilan');
      $object->getActiveSheet()->setCellValue('AU1', 'Total Skor Kejuaraan');
      $object->getActiveSheet()->setCellValue('AV1', 'Total Rata-rata nilai');
      $object->getActiveSheet()->setCellValue('AW1', 'Skor Ranking');
      $object->getActiveSheet()->setCellValue('AX1', 'Total Skor');
      $object->getActiveSheet()->setCellValue('AY1', 'Jarak');
      $object->getActiveSheet()->setCellValue('AZ1', 'Status Daftar');
      $object->getActiveSheet()->setCellValue('AAA1', 'R.SEMENTARA');
      $object->getActiveSheet()->setCellValue('AAB1', 'Proses By');
    } elseif ($jalur == 2) {
      $object->getActiveSheet()->setCellValue(
        'AO1',
        'Jenis Afirmasi'
      );
      $object->getActiveSheet()->setCellValue('AP1', 'Nama DI Kartu');
      $object->getActiveSheet()->setCellValue('AQ1', 'no Kartu');
      $object->getActiveSheet()->setCellValue('AR1', 'ID DTKS');
      $object->getActiveSheet()->setCellValue('AS1', 'Total Rata-rata nilai');
      $object->getActiveSheet()->setCellValue('AT1', 'Skor Nilai Rangking');
      $object->getActiveSheet()->setCellValue('AU1', 'Total Skor Nilai');
      $object->getActiveSheet()->setCellValue('AV1', 'Jarak');
      $object->getActiveSheet()->setCellValue('AW1', 'Status Daftar');
      $object->getActiveSheet()->setCellValue('AX1', 'R.SEMENTARA');
      $object->getActiveSheet()->setCellValue('AY1', 'Proses By');
    } else {
      $object->getActiveSheet()->setCellValue('AO1', 'Total Rata-rata nilai');
      $object->getActiveSheet()->setCellValue('AP1', 'Skor Rangking');
      $object->getActiveSheet()->setCellValue('AQ1', 'Total Skor nilai');
      $object->getActiveSheet()->setCellValue('AR1', 'Jarak');
      $object->getActiveSheet()->setCellValue('AS1', 'Status Daftar');
      $object->getActiveSheet()->setCellValue('AT1', 'R.SEMENTARA');
      $object->getActiveSheet()->setCellValue('AU1', 'Proses By');
    }
    $sheet = $object->getActiveSheet();

    $baris = 2;
    $no = 1;
    foreach ($data['pendaftar'] as $daftar) {
      $object->getActiveSheet()->setCellValue('A' . $baris, $no++);
      $object->getActiveSheet()->setCellValue('B' . $baris, $daftar->noDaftar);
      $sheet->getStyle('C' . $baris)->getNumberFormat()->setFormatCode('0'); 
      $object->getActiveSheet()->setCellValue('C' . $baris, $daftar->koreg);
      $object->getActiveSheet()->setCellValue('D' . $baris, $daftar->nama);
      $object->getActiveSheet()->setCellValue('E' . $baris, $daftar->jk);
      $object->getActiveSheet()->setCellValue('F' . $baris, $daftar->tempatLahir);
      $object->getActiveSheet()->setCellValue('G' . $baris, $daftar->tglLahir);
      $object->getActiveSheet()->setCellValue('H' . $baris, $daftar->usia);
      $object->getActiveSheet()->setCellValueExplicit('I' . $baris, $daftar->nik, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
      $object->getActiveSheet()->setCellValueExplicit('J' . $baris, $daftar->kk, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
      $object->getActiveSheet()->setCellValue('K' . $baris, $daftar->nisnSiswa,\PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
      $object->getActiveSheet()->setCellValue('L' . $baris, $daftar->noHp);
      $object->getActiveSheet()->setCellValue('M' . $baris, $daftar->tinggiBadan);
      $object->getActiveSheet()->setCellValue('N' . $baris, $daftar->beratBadan);
      $object->getActiveSheet()->setCellValue('O' . $baris, $daftar->agama);
      $object->getActiveSheet()->setCellValue('P' . $baris, $daftar->sekolahAsal);
      $object->getActiveSheet()->setCellValue('Q' . $baris, $daftar->npsn);
      $object->getActiveSheet()->setCellValue('R' . $baris, $daftar->ppdb);
      $object->getActiveSheet()->setCellValue('S' . $baris, $daftar->alamat);
      $object->getActiveSheet()->setCellValue('T' . $baris, $daftar->rt);
      $object->getActiveSheet()->setCellValue('U' . $baris, $daftar->rw);
      $object->getActiveSheet()->setCellValue('V' . $baris, $daftar->desa);
      $object->getActiveSheet()->setCellValue('W' . $baris, $daftar->kecamatan);
      $object->getActiveSheet()->setCellValue('X' . $baris, $daftar->kota);
      $object->getActiveSheet()->setCellValue('Y' . $baris, $daftar->provinsi);
      $object->getActiveSheet()->setCellValue('Z' . $baris, $daftar->kodePos);
      $object->getActiveSheet()->setCellValue('AA' . $baris, $daftar->longitude);
      $object->getActiveSheet()->setCellValue('AB' . $baris, $daftar->ayah);
      $object->getActiveSheet()->setCellValueExplicit('AC' . $baris, $daftar->nikAyah, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
      $object->getActiveSheet()->setCellValue('AD' . $baris, $daftar->TanggalLahirAyah);
      $object->getActiveSheet()->setCellValue('AE' . $baris, $daftar->pendidikanAyah);
      $object->getActiveSheet()->setCellValue('AF' . $baris, $daftar->pekerjaanAyah);
      $object->getActiveSheet()->setCellValue('AG' . $baris, $daftar->penghasilanAyah);
      $object->getActiveSheet()->setCellValue('AH' . $baris, $daftar->ibu);
      $object->getActiveSheet()->setCellValueExplicit('AI' . $baris, $daftar->kk, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
      $object->getActiveSheet()->setCellValue('AJ' . $baris, $daftar->TanggalLahirIbu);
      $object->getActiveSheet()->setCellValue('AK' . $baris, $daftar->pendidikanIbu);
      $object->getActiveSheet()->setCellValue('AL' . $baris, $daftar->pekerjaanIbu);
      $object->getActiveSheet()->setCellValue('AM' . $baris, $daftar->penghasilanIbu);
      $object->getActiveSheet()->setCellValue('AN' . $baris, $daftar->anak_ke);

      if ($jalur == 4) {
        $status = '';
        if ($daftar->statusDaftar == 2 || $daftar->statusDaftar == 1) {
          $status = 'Belum Verifikasi';
        } elseif ($daftar->statusDaftar == 3) {
          $status = 'Teverivikasi';
        } elseif ($daftar->lulus == 4) {
          $status = 'Diterima';
        } elseif ($daftar->lulus == 5) {
          $status = 'Tidak Diterima';
        } else {
          $status = 'Terverifikasi';
        }
        $object->getActiveSheet()->setCellValue('AO' . $baris, $daftar->namaKejuaraan);
        $object->getActiveSheet()->setCellValue('AP' . $baris, $daftar->peyelengara);
        $object->getActiveSheet()->setCellValue('AQ' . $baris, $daftar->kejuaraan);
        $object->getActiveSheet()->setCellValue('AR' . $baris, $daftar->satuan);
        $object->getActiveSheet()->setCellValue('AS' . $baris, $daftar->score);
        $object->getActiveSheet()->setCellValue('AT' . $baris, $daftar->skorKompetensi);
        $object->getActiveSheet()->setCellValue('AU' . $baris, ($daftar->skorKompetensi) + ($daftar->score));
        if($cekJalur['input_nilai']==1){
          $object->getActiveSheet()->setCellValue('AV' . $baris, $daftar->total);
          $object->getActiveSheet()->setCellValue('AW' . $baris, $daftar->skorRank);
          $object->getActiveSheet()->setCellValue('AX' . $baris, $daftar->totalSkor);
        }
        $object->getActiveSheet()->setCellValue('AY' . $baris, $daftar->jarak);
        $object->getActiveSheet()->setCellValue('AZ' . $baris, $status);
        $object->getActiveSheet()->setCellValue('AAA' . $baris, $daftar->kelRombel);
        $object->getActiveSheet()->setCellValue('AAB' . $baris, $daftar->prosesBy);
      } elseif ($jalur == 2) {
        $status = '';
        if ($daftar->statusDaftar == 2 || $daftar->statusDaftar == 1) {
          $status = 'Belum Verifikasi';
        } elseif ($daftar->statusDaftar == 3) {
          $status = 'Teverivikasi';
        } elseif ($daftar->lulus == 4) {
          $status = 'Diterima';
        } elseif ($daftar->lulus == 5) {
          $status = 'Tidak Diterima';
        } else {
          $status = 'Terverifikasi';
        }
        $object->getActiveSheet()->setCellValue('AO' . $baris, $daftar->nama_jenis_afirmasi);
        $object->getActiveSheet()->setCellValue('AP' . $baris, $daftar->nama_afirmasi);
        $object->getActiveSheet()->setCellValue('AQ' . $baris, $daftar->no_afirmasi);
        $object->getActiveSheet()->setCellValue('AR' . $baris, $daftar->dtks);
        $cekJalurAfir = CekData::getInfoJalur($jalur);
        if($cekJalurAfir['input_nilai']==1){
          $object->getActiveSheet()->setCellValue('AS' . $baris, $daftar->total);
          $object->getActiveSheet()->setCellValue('AT' . $baris, $daftar->skorRank);
          $object->getActiveSheet()->setCellValue('AU' . $baris, $daftar->totalSkor);
        }
        $object->getActiveSheet()->setCellValue('AV' . $baris, $daftar->jarak);
        $object->getActiveSheet()->setCellValue('AW' . $baris, $status);
        $object->getActiveSheet()->setCellValue('AX' . $baris, $daftar->kelRombel);
        $object->getActiveSheet()->setCellValue('AY' . $baris, $daftar->prosesBy);
      } else {
        $status = '';
        if ($daftar->statusDaftar == 2 || $daftar->statusDaftar == 1) {
          $status = 'Belum Verifikasi';
        } elseif ($daftar->statusDaftar == 3) {
          $status = 'Teverivikasi';
        } elseif ($daftar->lulus == 4) {
          $status = 'Diterima';
        } elseif ($daftar->lulus == 5) {
          $status = 'Tidak Diterima';
        } else {
          $status = 'Terverifikasi';
        }
        $cekJalur = CekData::getInfoJalur($jalur);
        if($cekJalur['input_nilai']==1){
          $object->getActiveSheet()->setCellValue('AO' . $baris, $daftar->total);
          $object->getActiveSheet()->setCellValue('AP' . $baris, $daftar->skorRank);
          $object->getActiveSheet()->setCellValue('AQ' . $baris, $daftar->totalSkor);
        }
       
        $object->getActiveSheet()->setCellValue('AR' . $baris, $daftar->jarak);
        $object->getActiveSheet()->setCellValue('AS' .  $baris, $status);
        $object->getActiveSheet()->setCellValue('AT' . $baris, $daftar->kelRombel);
        $object->getActiveSheet()->setCellValue('AU' . $baris, $daftar->prosesBy);
      }
     
      $baris++;
    }
  
    $file_name = "Data Pendaftar" . '.xlsx';
    $writer = new Xlsx($object);
    $object->getActiveSheet()->setTitle("Data Pendaftar");
    header('Content-Type:application/vnd.openxmlFormats-officedocument.spreadsheetml.sheet');
    header('Cache-Control:max-age=0');
    header('Content-Type: application/vnd.ms-excel');
    // header('Content-Disposition: attachment;filename="hello_world.xlsx"');
    header('Content-Disposition:attachment; filename="' . $file_name . '"');
    // $writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
    ob_end_clean();
    $writer->save('php://output');
    exit;
  }






  public function Lampiran()
  {
    $data['pendaftar'] = $this->daftar->getDataLulusExcel();
    $sekolah = $this->db->get_where('kop_surat', ['id' => 1])->row_array();
    $object = new Spreadsheet();
    $object->getProperties()->setCreator('Lampiran SK Diterima');
    $object->getProperties()->setLastModifiedBy('Data PPDB');
    $object->getProperties()->setTitle('Data Pendaftar');
    $object->setActiveSheetIndex(0);
    $object->getActiveSheet()->setCellValue('A1', 'Lampiran');
    $object->getActiveSheet()->setCellValue('B1', ':');
    $object->getActiveSheet()->setCellValue('C1', 'SURAT KEPUTUSAN KEPALA ' . $sekolah['nama_sekolah']);
    $object->getActiveSheet()->setCellValue('A2', 'Nomor');
    $object->getActiveSheet()->setCellValue('B2', ':');
    $object->getActiveSheet()->setCellValue('C2',  $sekolah['no_surat']);
    $object->getActiveSheet()->setCellValue('A3', 'Tanggal');
    $object->getActiveSheet()->setCellValue('B3', ':');
    $object->getActiveSheet()->setCellValue('C3',  $sekolah['tanggalKelulusan']);
    $sheet = $object->getActiveSheet();
    $style = [
      'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
      ],
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM,
          'color' => ['argb' => '0000'],
        ],
      ],
    ];

    $style2 = [
      'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
      ],
    ];


    $sheet->getStyle("A6:E6")->applyFromArray($style2);
    $sheet->getStyle("A7:E7")->applyFromArray($style2);
    $sheet->getStyle("A8:E8")->applyFromArray($style2);
    $sheet->getStyle("A11")->applyFromArray($style);
    $sheet->getStyle("A12")->applyFromArray($style);
    $sheet->getStyle("B12")->applyFromArray($style);
    $sheet->getStyle("B11")->applyFromArray($style);
    $sheet->getStyle("C11")->applyFromArray($style);
    $sheet->getStyle("C12")->applyFromArray($style);
    $sheet->getStyle("D11")->applyFromArray($style);
    $sheet->getStyle("D12")->applyFromArray($style);
    $sheet->getStyle("E11")->applyFromArray($style);
    $sheet->getStyle("E12")->applyFromArray($style);
    $object->getActiveSheet()->setCellValue('A7', 'PADA PENERIMAAN PESERTA DIDIK BARU');
    $object->getActiveSheet()->setCellValue('A8', 'TAHUN PELAJARAN');
    $object->getActiveSheet()->setCellValue('A6', 'DAFTAR NAMA CALON PESERTA DIDIK BARU YANG DITERIMA');
    $object->getActiveSheet()->setCellValue('A11', 'Nomor');
    $sheet->mergeCells('A6:E6');
    $sheet->mergeCells('A7:E7');
    $sheet->mergeCells('A8:E8');
    $sheet->mergeCells('A11:B11');
    $sheet->mergeCells('C11:C12');
    $sheet->mergeCells('D11:D12');
    $sheet->mergeCells('E11:E12');
    $object->getActiveSheet()->setCellValue('A12', 'Urut');
    $object->getActiveSheet()->setCellValue('B12', 'Daftar');
    $object->getActiveSheet()->setCellValue('C11', 'Nama Lengkap');
    $object->getActiveSheet()->setCellValue('D11', 'Sekolah Asal');
    $object->getActiveSheet()->setCellValue('E11', 'Jalur PPDB');
    $baris = 13;
    $no = 1;
    foreach ($data['pendaftar'] as $daftar) {
      $sheet->getStyle('A' . $baris)->applyFromArray($style);
      $sheet->getStyle('B' . $baris)->applyFromArray($style);
      $sheet->getStyle('B' . $baris)->getNumberFormat()->setFormatCode('0'); 

      $object->getActiveSheet()->setCellValue('A' . $baris, $no++);
      $object->getActiveSheet()->setCellValue('B' . $baris, $daftar->koreg);
      $object->getActiveSheet()->setCellValue('C' . $baris, $daftar->nama);
      $object->getActiveSheet()->setCellValue('D' . $baris, $daftar->sekolahAsal);
      $object->getActiveSheet()->setCellValue('E' . $baris, $daftar->ppdb);
      $baris++;
    }
    $file_name = "Lampira Sk Diterima" . '.xlsx';
    $writer = new Xlsx($object);
    $object->getActiveSheet()->setTitle("Lampiran SK Diterima");
    header('Content-Type:application/vnd.openxmlFormats-officedocument.spreadsheetml.sheet');
    header('Cache-Control:max-age=0');
    header('Content-Type: application/vnd.ms-excel');
    // header('Content-Disposition: attachment;filename="hello_world.xlsx"');
    header('Content-Disposition:attachment; filename="' . $file_name . '"');
    // $writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
    ob_end_clean();
    $writer->save('php://output');
    exit;
  }

  // get data penyelengara
  public function penyelengara()
  {
    echo json_encode($this->item_m->dataPeyelengara()->result_array());
  }

  

  // get data jenis afirmasi
  public function jenisAfirmasi()
  {
    echo json_encode($this->item_m->jenisAfirmasi()->result_array());
  }
  // memilih kategori kejuaraan berdasarkan penyelengagara
  public function KategoriKejuaraan()
  {
    echo json_encode($this->item_m->KategoriKejuaraan($_POST['id'])->result_array());
  }

 


  public function KategoriKejuaraanAll()
  {
    echo json_encode($this->db->get('kat_satuan')->result_array());
  }
  // / get data afirmasi by id
 
  

  public function tingkatPrestasi()
  {
    echo json_encode($this->item_m->tingkatKejuaraan($_POST['id'])->result_array());
  }
  //   cetak bukti pendaftaran
  public function PrintBuktiRegistrasi2($koreg)
  {
    if(!isset($koreg)){
      redirect('Admin');
  }
  $this->load->model('Pendaftar_m','operator');
  $data= $this->operator->getdataprintByjalur($koreg);
  $mpdf = new \Mpdf\Mpdf(['debug' => false,
      'format' => 'Legal-P',
      'margin_left' => 22,
      'margin_right' => 20,
      'margin_top' => 15,
      'margin_bottom' => 0,
      'margin_header' => 0,
      'margin_footer' => 0,
  ]);
  $html = '';

  $html = $this->load->view('Home2/Cetak', $data, true);
  $html2 = $this->load->view('Home2/perjanjianMutlakOrangtua', $data, true);
  $mpdf->WriteHTML($html);
  $mpdf->AddPage();
  $mpdf->WriteHTML($html2);
  $mpdf->SetHTMLFooter('
<table width="100%">
  <tr>
      <td width="33%" style="font-size:8px;">{DATE j-m-Y}</td>
      <td width="33%" align="center" style="font-size:8px;">{PAGENO}/{nbpg}</td>
      <td width="33%" style="text-align: right; font-size:8px;">' . $data['dataSekolah']['nama_sekolah']  . '</td>
  </tr>
</table>');
  $mpdf->Output($koreg . '-' . $data['user']['nama'] . '-' . $data['user']['sekolahAsal'] . '-' . $data['user']['nisn'] . '.pdf', 'I');
  }
}
