<?php
defined('BASEPATH') or exit('No direct script access allowed');
class User_model extends CI_Model
{
  public function editProsesUser($data)
  {

    $user = [
      'name' => $data['nama'],
      'email' => $data['email'],
      'role_id' => $data['userAkses'],
    ];

    $this->db->set($user);
    $this->db->where('id', $data['idUser']);
    $this->db->update('user');
    return $this->db->affected_rows();
  }

  public function editProsesOperator($data)
  {

    $user = [
      'name' => $data['nama'],
      'asal_sekolah_ops' => $data['namaSekolahOps'],
      'npsnOps' => $data['npsnOps']
    ];

    $this->db->set($user);
    $this->db->where('id', $data['idOperator']);
    $this->db->update('user');
    return $this->db->affected_rows();
  }

  public function KosongkanDatabase()
  {
    if (empty($this->session->userdata('email'))) {
      return 0;
    } else {
      $this->db->empty_table('register');
      $this->db->empty_table('nilai');
      $this->db->empty_table('afirmasi');
      $this->db->empty_table('kejuaraansiswa');
      $this->db->empty_table('wali');
      $this->db->empty_table('kejuaraansiswa');
      return 1;
    }
    // $user['user'] = $this->db->get('register')->result_array();
    // foreach ($user['user'] as $u) {
    //   $this->db->delete('nilai', ['id_pendaftar' => $u['id']]);
    //   $this->db->delete('afirmasi', ['id_pendaftar' => $u['id']]);
    //   $this->db->delete('kejuaraansiswa', ['id_pendaftar' => $u['id']]);
    //   $this->db->delete('wali', ['idRegister' => $u['id']]);
    //   $this->db->delete('register', ['id' => $u['id']]);
    // }
    // return $this->db->affected_rows();
  }

  public function tambahProsesUser($data)
  {


    $user = [
      'name' => $data['nama'],
      'email' => $data['email'],
      'image' => 'default.jpg',
      'password' => password_hash($data['password'], PASSWORD_DEFAULT),
      'role_id' => $data['userAkses'],
      'is_active' => 1,
      'date_created' => time()
    ];

    $this->db->insert('user', $user);
    return $this->db->affected_rows();
  }

  public function tambahUserOperator($data)
  {
    $user = [
      'name' => $data['nama'],
      'email' => $data['email'],
      'image' => 'default.jpg',
      'asal_sekolah_ops' => $data['namaSekolahOps'],
      'npsnOps' => $data['npsnOps'],
      'password' => password_hash($data['password'], PASSWORD_DEFAULT),
      'role_id' => 5,
      'is_active' => 1,
      'date_created' => time()
    ];

    $this->db->insert('user', $user);
    return $this->db->affected_rows();
  }


  public function hapusUserProses($id)
  {
    $this->db->delete('user', ['id' => $id]);
    return $this->db->affected_rows();
  }

  public function prosesTambahDesa($desa)
  {
    $user = [
      'id' => $this->idDesa(),
      'name' => $desa['namaDesa'],
      'district_id' => $desa['kecamatan'],
    ];

    $this->db->insert('villages', $user);
    return $this->db->affected_rows();
  }

  public function  idDesa()
  {
    $this->db->select_max('id', 'idDesa');
    $query = $this->db->get('villages')->row_array();
    $idHasil = $query['idDesa'] + 1;
    return $idHasil;
  }

  public function prosesResetCabut($post)
  {
    $user = [
      'statusDaftar' => $post['cabutKe'],
    ];
    $this->db->set($user);
    $this->db->where('koreg', $post['Koreg']);
    $this->db->update('register');
    return $this->db->affected_rows();
  }

  public function resetPeserta($nisn)
  {
    $data = [];
    $cek = $this->db->get_where('register', ['nisn' => $nisn])->row_array();
    if (!$cek) {
      $data = ['pesan' => 'noUser'];
      return $data;
      exit;
    } else {
      $karakter = '123456789';
      $shuffle  = substr(str_shuffle($karakter), 0, 5);
      $data = [
        'pesan' => 'ada',
        'user' => $cek['nama'],
        'newPIN' => $shuffle,
        'nisn' => $cek['nisn']
      ];

      if ($this->updateUser($data) > 0) {
        return $data;
      } else {
        $data = ['pesan' => 'gagal'];
        return $data;
      }
    }
  }

  public function resetOperator($id)
  {
    $data = [];
    $cek = $this->db->get_where('user', ['id' => $id])->row_array();
    if (!$cek) {
      $data = ['pesan' => 'noUser'];
      return $data;
      exit;
    } else {
      $karakter = '123456789';
      $shuffle  = substr(str_shuffle($karakter), 0, 5);
      $data = [
        'pesan' => 'ada',
        'id' => $cek['id'],
        'name' => $cek['name'],
        'asal_sekolah_ops' => $cek['asal_sekolah_ops'],
        'newPIN' => $shuffle,
        'npsnOps' => $cek['npsnOps']
      ];

      if ($this->updateUserOperator($data) > 0) {
        return $data;
      } else {
        $data = ['pesan' => 'gagal'];
        return $data;
      }
    }
  }

  private function updateUserOperator($data)
  {
    $user = [
      'password' => password_hash(($data['newPIN']), PASSWORD_DEFAULT),
    ];

    $this->db->set($user);
    $this->db->where('id', $data['id']);
    $this->db->update('user');
    return $this->db->affected_rows();
  }



  private function updateUser($data)
  {
    $user = [
      'pin' => password_hash(($data['newPIN']), PASSWORD_DEFAULT),
    ];

    $this->db->set($user);
    $this->db->where('nisn', $data['nisn']);
    $this->db->update('register');
    return $this->db->affected_rows();
  }
}
