function getURL() {
	let url = $(".url").data("url");
	return url;
  }
  
$(function () {

	// leav stev
	$("#smartwizard").on("leaveStep", function(e, anchorObject, currentStepIdx, nextStepIdx, stepDirection) {
	// Validate only on forward movement
		if(stepDirection =='forward'){
			let form = document.getElementById('form-' + (currentStepIdx + 1));
			let id = $(form).attr('id');
			let action = $(form).attr('action');
			if ($('#' + id).valid()) {
				$.ajax({
					method: "POST",
					dataType: "json",
					url:action,
					data: $(form).serialize(),
					beforeSend: function( xhr ) {
						// Show the loader
					$('#smartwizard').smartWizard("loader", "show");
					},
					success: function (respon) {
						if (respon.pesan == "ok") {
							$('#smartwizard').smartWizard("unsetState", [currentStepIdx], 'error');
							Swal.fire({
								icon: "success",
								title: "Sukses",
								text: 'Data Tersimpan',
							});
							$('#smartwizard').smartWizard("loader", "hide");
							return true;
						} else {
							$('#smartwizard').smartWizard("setState",[currentStepIdx],'error');
							$('#smartwizard').smartWizard("goToStep", currentStepIdx);
							$('#smartwizard').smartWizard("loader", "hide");
							return false
						}
					}
				}).fail(function (err) {
					Swal.fire({
						icon: "error",
						title: "Server Error",
						text: err,
					});
					$('#smartwizard').smartWizard("setState",[currentStepIdx],'error');
					$('#smartwizard').smartWizard("loader", "hide");
					$('#smartwizard').smartWizard("goToStep", currentStepIdx);
					return false
				});
					
				// jika validasion error
				} else {
					// jika valid data nya erro
				$('#smartwizard').smartWizard("setState", [currentStepIdx], 'error');
				$('#smartwizard').smartWizard("goToStep", currentStepIdx);
					return false
				}
		}
	});
	$("#smartwizard").on("showStep", function(e, anchorObject, stepIndex, stepDirection, stepPosition) {
		$("#prev-btn").removeClass('disabled').prop('disabled', false);
		$("#next-btn").removeClass('disabled').prop('disabled', false);
		if(stepPosition === 'first') {
			$("#prev-btn").addClass('disabled').prop('disabled', true);
		} else if (stepPosition === 'last') {
			$("#btnAkhiriPendaftaran").prop('disabled', false);
			$(".sw-next-btn").removeClass('disabled').prop('disabled', true);
		} else {
			$("#prev-btn").removeClass('disabled').prop('disabled', false);
			$("#next-btn").removeClass('disabled').prop('disabled', false);
		}
	})

	
$('#smartwizard').smartWizard({
	selected: 0, // Initial selected step, 0 = first step
	theme: 'arrows',
	autoAdjustHeight: false, // Automatically adjust content height
	toolbar: {
		position: 'bottom', // none|top|bottom|both
		showNextButton: true, // show/hide a Next button
		showPreviousButton: true, // show/hide a Previous button
		extraHtml: '<button class="btn btn-success" id="btnAkhiriPendaftaran" disabled onclick="savePendaftran()">Akhiri Pendaftaran</button>',
		justified: true, // Extra html to show on toolbar
	},
	lang: { // Language variables for button
		next: 'Selanjutnya',
		previous: 'Kembali'
	},
	anchor: {
		enableNavigation: true, // Enable/Disable anchor navigation 
		enableNavigationAlways: false, // Activates all anchors clickable always
		enableDoneState: true, // Add done state on visited steps
		markPreviousStepsAsDone: true, // When a step selected by url hash, all previous steps are marked done
		unDoneOnBackNavigation: false, // While navigate back, done state will be cleared
		enableDoneStateNavigation: true // Enable/Disable the done state navigation
	},
	// disabledSteps: [0, 1],
	// hiddenSteps: [2,3] // Hidden steps

	  
});
	
	

	
$('#form-1').validate({
	focusInvalid: true,
	invalidHandler: function (form, validator) {
	  Swal.fire({
		icon: "error",
		title: "Belum lengkap !!!",
		text: "Cek kembali sebelum ke isian selanjutnya ",
		timer: 2000,
	  });
	  if (!validator.numberOfInvalids()) return;
  
	  $("html, body").animate(
		{
		  scrollTop: $(validator.errorList[0].element).offset().top - 190,
		},
		3000
	  );
	},
	rules: rolesFormBiodata(),
	messages: messageErrorBiodata(),
  });


$('#form-2').validate({
	focusInvalid: true,
	invalidHandler: function (form, validator) {
	  Swal.fire({
		icon: "error",
		title: "Belum lengkap !!!",
		text: "Cek kembali sebelum ke isian selanjutnya  ",
		timer: 2000,
	  });
	  if (!validator.numberOfInvalids()) return;
  
	  $("html, body").animate(
		{
		  scrollTop: $(validator.errorList[0].element).offset().top - 190,
		},
		3000
	  );
	},
	rules: rolesFormWali(),
	messages: messageErrorWali(),
  });

$('#form-3').validate({
	focusInvalid: true,
	invalidHandler: function (form, validator) {
	  Swal.fire({
		icon: "error",
		title: "Belum lengkap !!!",
		text: "Cek kembali sebelum ke isian selanjutnya  ",
		timer: 2000,
	  });
	  if (!validator.numberOfInvalids()) return;
  
	  $("html, body").animate(
		{
		  scrollTop: $(validator.errorList[0].element).offset().top - 190,
		},
		3000
	  );
	},
	rules: rolesFormBerkas(),
	messages: messageErrorBerkas(),
});
	


	
// function validation form biodata
function rolesFormBiodata() {
	let roles = {
	  agama: {
		required: true,
	  },
	  anak_ke: {
		required: true,
	  },
	  nama: {
		required: true,
	  },
	  nik: {
		required: true,
		number: true,
		  rangelength: [16, 16],
		  remote: function () {
			let checkit = {
			  type: "POST",
			  url: baseUrl() + "Akun/CekNIK",
			  // contentType: "application/json; charset=utf-8",
			  dataType: "json",
			  data: {
				nisnsiswa: $("#nik").val(),
			  },
			};
			return checkit;
		  },
	  },
	  nisn: {
		rangelength: [10, 10],
		required: true,
		remote: function () {
		  let checkit = {
			type: "POST",
			url: baseUrl() + "Akun/CekNisn",
			// contentType: "application/json; charset=utf-8",
			dataType: "json",
			data: {
			  nisnsiswa: $("#nisn").val(),
			},
		  };
		  return checkit;
		},
	  },
	  email: {
		required: true,
		email:true,
		remote: function () {
		  let checkit = {
			type: "POST",
			url: baseUrl() + "Akun/CekEmail",
			// contentType: "application/json; charset=utf-8",
			dataType: "json",
			data: {
			  email: $("#email").val(),
			},
		  };
		  return checkit;
		},
	  },
	  tempatLahir: {
		required: true,
	  },
	  tglLahir: {
		required: true,
	  },
	  jk: {
		required: true,
	  },
	  noHp: {
		required: true,
		number: true,
		rangelength: [11, 13],
	  },
	  tinggiBadan: {
		required: true,
	  },
	  beratBadan: {
		required: true,
	  },
	  sekolahAsal: {
		required: true,
	  },
	  npsn: {
		required: true,
	  },
	  provinsi: {
		required: true,
	  },
	  kota: {
		required: true,
	  },
	  kk: {
		required: true,
		number: true,
		rangelength: [16, 16],
	  },
	  kecamatan: {
		required: true,
	  },
	  desa: {
		required: true,
	  },
	  rt: {
		required: true,
		rangelength: [1, 3],
	  },
	  rw: {
		required: true,
		rangelength: [1, 3],
	  },
	  kodePos: {
		required: true,
		rangelength: [1, 7],
	  },
	  alamat: {
		required: true,
	  },
	  longitude: {
		required: true,
		strongCoord: true,
	  },
	};
  
	return roles;
  }
  
//  function error form biodata
function messageErrorBiodata() {
	let msg = {
	  nama: {
		required: "Nama Pendaftar Harus Diisi",
	  },
	  nik: {
		required: "NIK Wajib diisi",
		number: "Hanya Angka Yg Di inpu",
		  rangelength: "NIK harus 16 digit/angka",
		remote:'NIK Harus sudah didaftarkan'
	  },
	  nisn: {
		required: "NISN harus di isi",
		remote: "nisn sudah digunakan",
		rangelength: "nisn tidak kurang dan lebih dari 10 digit",
	  },
	  email: {
		required: "Email harus di isi",
		remote: 'Email sudah di gunakan',
		email:'Format Email Sudah Digunakan'
	  },
	  tempatLahir: {
		required: "tempat lahir harus disi",
	  },
	  tglLahir: {
		required: "Tanggal belum dipilih",
	  },
	  jk: {
		required: "Jenis kelamin belum di pilih",
	  },
	  noHp: {
		required: "No handphone harus diisi",
		number: "Input hanya angka",
		rangelength: "Min : 11  & max:13 digit",
	  },
	  tinggiBadan: {
		required: "tinggi badan harus disi",
	  },
	  beratBadan: {
		required: "Berat badan harus di isi",
	  },
	  sekolahAsal: {
		required: "Asal Sekolah Dasar Harus Diisi",
	  },
	  npsn: {
		required: "NPSN Sekolah Dasar Tidak Boleh Kosong",
	  },
	  kk: {
		required: "kaka Harus di isi",
		required: "KK Wajib diisi",
		number: "Hanya Angka Yg Di inpu",
		rangelength: "KK harus 16 digit/angka",
	  },
	  provinsi: {
		required: "Provinsi belum dipilih",
	  },
	  kota: {
		required: "Kota Belum Dipilih",
	  },
	  agama: {
		required: "Kolom isian agama belum di pilih",
	  },
	  anak_ke: {
		required: "Status anak ke- belum di pilih",
	  },
	  kecamatan: {
		required: "Kecamatan belum dipilih",
	  },
	  desa: {
		required: "desa belum dipilih",
	  },
	  rt: {
		required: "Rt Harus Diisi",
		rangelength: "Max 3 Digit",
	  },
	  rw: {
		required: "rw harus diisi",
		rangelength: "Max 3 Digit",
	  },
	  kodePos: {
		required: "Kode Pos harus disi",
		rangelength: "Max 7 Digit",
	  },
	  alamat: {
		required: "Alamat masih kosong",
	  },
	  longitude: {
		required: "Longitude Wajib Di isi",
	  },
	};
	return msg;
  }
  
// funtion roles Wali
function rolesFormWali() {
	let roles = {
	  ayah: {
		required: true,
	  },
	  nikAyah: {
		required: true,
		number: true,
		rangelength: [16, 16],
	  },
	  tanggalLahirAyah: {
		required: true,
	  },
	  pendidikanAyah: {
		required: true,
	  },
	  pekerjaanAyah: {
		required: true,
	  },
	  penghasilanAyah: {
		required: true,
	  },
	  //  ibu
	  ibu: {
		required: true,
	  },
	  nikIbu: {
		required: true,
		number: true,
		rangelength: [16, 16],
	  },
	  tanggalLahirIbu: {
		required: true,
	  },
	  pendidikanIbu: {
		required: true,
	  },
	  pekerjaanIbu: {
		required: true,
	  },
	  penghasilanIbu: {
		required: true,
	  },
	  notelepon: {
		required: true,
		number: true,
		rangelength: [11, 13],
	  },
	};
  
	return roles;
	}
	
	 
  //  function error form Wali
function messageErrorWali() {
	let msg = {
	  ayah: {
		required: "Nama Ayah wajib diisi (meninggal: ketik Alm.sebelum nama)",
	  },
	  nikAyah: {
		required: "Nik ayah harus di isi",
		number: "nik harus number",
		rangelength: "NIK tidak kurang/lebih 16 digit",
	  },
	  tanggalLahirAyah: {
		required: "silahkan pilih tanggal lahir",
	  },
	  pendidikanAyah: {
		required: "pendidikan belum dipilih",
	  },
	  pekerjaanAyah: {
		required: "pekerjaan belum dipilih",
	  },
	  penghasilanAyah: {
		required: "penghasilan belum dipilih",
	  },
	  //  ibu
	  ibu: {
		required: "Nama Ibu wajib diisi (meninggal: ketik Almh.sebelum nama)",
	  },
	  nikIbu: {
		required: "nik masih kosong",
		number: "nik harus number",
		rangelength: "nik tidak kurang/lebih 16 digit",
	  },
	  tanggalLahirIbu: {
		required: "tanggal lahir belum dipilih",
	  },
	  pendidikanIbu: {
		required: "pendidikan ibu belum dipilih",
	  },
	  pekerjaanIbu: {
		required: "pekerjaan belum dipilih",
	  },
	  penghasilanIbu: {
		required: "penghasilan belum dipilih",
	  },
	  notelepon: {
		required: "No telepon masih kosong",
		number: "No telepon harus number",
		rangelength: "Telapon tidak kurang 11 & lebih 13 digit",
	  },
	};
	return msg;
  }

//   pilih jalur ppdb
// pilih jalur ppdb=======================================
$(".jalurPpdb").on("change", function () {
	var id = $(this).val();
	 $(".loading").css("top", "0");
	 $(".gambar-loading").css("opacity", "1");
	$.ajax({
	  url: baseUrl() + "Akun/changejalur",
	  method: "post",
	  data: {
		id: id,
	  },
	  dataType: "json",
		success: function (response) {
			if (response?.input_nilai == 1) {
					$(".content-syarat-khusus .raport").css("display", "block");
				} else {
				  $(".content-syarat-khusus .raport").css("display", "none");
				}
  
				if (response?.input_afirmasi == 1) {
					 $(".content-syarat-khusus .afirmasi").css("display", "block");
					$(".content-syarat-khusus .namaAfirmasi").html("");
					// $(".afirmasi .afirmasi-main .namaAfirmasi").html('')
				  dataAfirmasi();
				} else {
				  $(".content-syarat-khusus .afirmasi").css("display", "none");
				  
				}
  
				if (response?.inputPrestasi == 1) {
					dataPenyelengara();
				  $(".content-syarat-khusus .kejuaraan").css("display", "block");
				  $(".content-syarat-khusus .penyelengara").html("");
				  // Load data Kejuaraan
				} else {
				  $(".content-syarat-khusus .kejuaraan").css("display", "none");
				}
	  },
	  complete: function (xhr, status) {
		Swal.fire({
		  icon: "success",
		  title: `Jalur Behasil Di Pilih`,
		  text: status,
		});
		$(".loading").css("top", "100%");
		$(".gambar-loading").css("opacity", "0");
	  },
	  error: function (xhr, status, error) {
		Swal.fire({
		  icon: "error",
		  title: error,
		  text: status,
		});
	  },
	 
	});
});
	
	
// load jenis afirmasi]
function dataAfirmasi() {
	$.ajax({
	  url: baseUrl() + "Akun/jenisAfirmasi",
	  dataType: "json",
	  method: "post",
	  success: function (respon) {
		$(".afirmasi .afirmasi-main .namaAfirmasi").append(
		  `<option value="">Pilih nama afirmasi---</option>`
		);
		$.each(respon, function (i, v) {
		  $(".afirmasi .afirmasi-main .namaAfirmasi").append(
			`
					  <option value="` +
			  v.id +
			  `">` +
			  v.nama_jenis_afirmasi +
			  `</option>
				  `
		  );
		});
		$(".loading").css("top", "100%");
		$(".gambar-loading").css("opacity", "0");
	  },
	});
	}
	
	// memilih jenis Afirmasi
$(".afirmasi").on("change", ".namaAfirmasi", function () {
	$(".afirmasi-item1").html("");
	$(".afirmasi-item2").html("");
	var id = $(this).val()
	$(".loading").css("top", "0");
	$(".gambar-loading").css("opacity", "1");
	$.ajax({
	  url: baseUrl() + "Akun/getAfirmasiById",
	  dataType: "json",
	  method: "post",
	  data: {
		id: id,
	  },
	  success: function (respon) {
		if (respon == null) {
		  $(".afirmasi .afirmasi-item1").append(`
						  <div class="row my-3">
							  <div class="col-6 col-lg-6">
								  <p class="text-warning">Silahkan pilih jenis afirmasi</p>
							  </div>
						  </div>
							  
						  `);
		} else if (respon.id == 5) {
		  $(".afirmasi-item2").append("");
		} else {
		  $(".afirmasi-item2").append(
			`
						  <div class="row my-3">
							  <div class="col-6 col-lg-6">
								  <label for="namaPemilik">Nama Sesuai di Kartu ` +
			  respon.nama_jenis_afirmasi +
			  `</label>
								  <input type="text" class="form-control" name="namaPemilik" id="namaPemilik">
							  </div>
							  <div class="col-6 col-lg-6">
								  <label for="noKartu">No Kartu ` +
			  respon.nama_jenis_afirmasi +
			  `</label>
								  <input type="text" class="form-control" name="noKartu" id="noKartu">
							  </div>
						  </div>
						  <div class="row my-3">
							  <div class="col-6 col-lg-6">
								  <label for="dtks">No ID DTKS DINSOS</label>
								  <input type="text" class="form-control" name="dtks" id="dtks">
							  </div>
						  </div>
							  
						  `
		  );
		}
  
		$(".loading").css("top", "100%");
		$(".gambar-loading").css("opacity", "0");
	  },
	});
  });

	//   function loada data pyelengara
	function dataPenyelengara() {
	$.ajax({
	  url: baseUrl() + "Akun/penyelengara",
	  dataType: "json",
	  method: "post",
	  success: function (respon) {
		$(".kejuaraan-main .penyelengara").append(
		  `<option value="">Peyelengara Kejuaraan---</option>`
		);
		$.each(respon, function (i, v) {
		  $(".kejuaraan-main .penyelengara").append(
			`
				  <option value="` +
			  v.id_penyelengara +
			  `">` +
			  v.peyelengara +
			  `</option>
				  `
		  );
		});
		$(".loading").css("top", "100%");
		$(".gambar-loading").css("opacity", "0");
	  },
	});
  }

	// memilih kategori kejuaraan
	// memilih penyelengara dan menampilkan kategori kejuaraan
$(".container-berkas").on("change", ".penyelengara", function () {
	var id = $(this).val();
	$(".loading").css("top", "0");
	$(".gambar-loading").css("opacity", "1");
	$.ajax({
	  url: baseUrl() + "Akun/KategoriKejuaraan",
	  method: "post",
	  data: {
		id: id,
	  },
	  dataType: "json",
	  success: function (response) {
		 $(".container-berkas .kejuaraan-item1").html("");
		$(".kejuaraan-item1").append(`<label for="kategori_kejuaraan">Pilih Ketegori Kejuaraan</label>
		<select name="kategori_kejuaraan" id="kategori_kejuaraan" class="kategori_kejuaraan form-control form-control-sm">
		</select>
	   `);
		$(".container-berkas .kategori_kejuaraan").append(
		   `<option value="">--- Pilih Kategori Kejuaraan</option>`
		 )
	   $.each(response, function (i, v) {
		 $(".container-berkas .kategori_kejuaraan").append(
		   `
					  <option value="` +
			 v.id_satuan +
			 `">` +
			 v.satuan +
			 `</option>
				  `
		 );
	   });
	  },
	  complete: function (xhr, status) {
		$(".loading").css("top", "100%");
		$(".gambar-loading").css("opacity", "0");
	  },
	  error: function (xhr, status, error) {
		Swal.fire({
		  icon: "error",
		  title: error,
		  text: status,
		});
	  },
	});
  });


	// memilih tingkat prestasi berdasarkan kategori
$(".kejuaraan-item1").on("change", ".kategori_kejuaraan", function () {
	$(".kejuaraan-item2").html("");
	 $(".container-berkas .tingkat_kejuaraan").html(``);
	var id = $(this).val();
	$(".loading").css("top", "0");
	$(".gambar-loading").css("opacity", "1");
	$.ajax({
	  url: baseUrl() + "Akun/tingkatPrestasi",
	  method: "post",
	  data: {
		id: id,
	  },
	  dataType: "json",
	  success: function (response) {
		$(".container-berkas .kejuaraan-item2").html("");
		$(".kejuaraan-item2")
		  .append(`<label for="kategori_kejuaraan">Pilih Tingat Kejuaraan</label>
		<select name="tingkat_kejuaraan" id="tingkat_kejuaraan" class="tingkat_kejuaraan form-control form-control-sm">
		</select>
	   `);
		$(".container-berkas .tingkat_kejuaraan").append(
		  `<option value="">---Pilih tingkat Kejuaraan</option>`
		);
		$.each(response, function (i, v) {
		  $(".container-berkas .tingkat_kejuaraan").append(
			`
					  <option value="` +
			  v.id +
			  `">` +
			  v.kejuaraan +
			  `</option>
				  `
		  );
		});
	  },
	  complete: function (xhr, status) {
		$(".loading").css("top", "100%");
		$(".gambar-loading").css("opacity", "0");
	  },
	  error: function (xhr, status, error) {
		Swal.fire({
		  icon: "error",
		  title: error,
		  text: "Data gagal di muat status kode:"+status,
		});
	  },
	});
  });
  
  $(".container-berkas").on("change", ".tingkat_kejuaraan", function () {
	$(".kejuaraan-item3").html("");
	// dragGambar();
	// loadTingkatPrestasi(id)
	$(".loading").css("top", "0");
	$(".gambar-loading").css("opacity", "1");
	$(".kejuaraan-item3").append(`
				  <div class="row my-3">
					  <div class="col my3">
					  <label for="namaKejuaraan">Nama Kejuaran</label>
						  <input type="text" class="form-control form-control-custum" name="namaKejuaraan" id="namaKejuaraan">
					  </div>
				  </div>
			  `);
	$(".loading").css("top", "100%");
	$(".gambar-loading").css("opacity", "0");
  });
  
  
  // load data raport
  function dataNilaiRaport() {
		$.ajax({
			url: baseUrl() + "Akun/loadDataRaportByPendaftar",
			method: "post",
			data: {
				key: '34$8882998iu@!',
			},
			dataType: "json",
			success: function (response) {
				// console.info(response)
				// let data=(JSON.stringify(response.paiK4S1))
				//   $(".content-syarat-khusus .raport tbody").html("");
				$('.paiK4S1').val(response.paiK4S1)
				$('.paiK4S2').val(response.paiK4S2)
				$('.paiK5S1').val(response.paiK5S1)
				$('.paiK5S2').val(response.paiK5S2)
				$('.paiK6S1').val(response.paiK6S1)
				
				$('.pknK4S1').val(response.pknK4S1)
				$('.pknK4S2').val(response.pknK4S2)
				$('.pknK5S1').val(response.pknK5S1)
				$('.pknK5S2').val(response.pknK5S2)
				$('.pknK6S1').val(response.pknK6S1)
				
				$('.indoK4S1').val(response.indoK4S1)
				$('.indoK4S2').val(response.indoK4S2)
				$('.indoK5S1').val(response.indoK5S1)
				$('.indoK5S2').val(response.indoK5S2)
				$('.indoK6S1').val(response.indoK6S1)

				$('.mtkK4S1').val(response.mtkK4S1)
				$('.mtkK4S2').val(response.mtkK4S2)
				$('.mtkK5S1').val(response.mtkK5S1)
				$('.mtkK5S2').val(response.mtkK5S2)
				$('.mtkK6S1').val(response.mtkK6S1)

				$('.ipaK4S1').val(response.ipaK4S1)
				$('.ipaK4S2').val(response.ipaK4S2)
				$('.ipaK5S1').val(response.ipaK5S1)
				$('.ipaK5S2').val(response.ipaK5S2)
				$('.ipaK6S1').val(response.ipaK6S1)
				
				$('.ipsK4S1').val(response.ipsK4S1)
				$('.ipsK4S2').val(response.ipsK4S2)
				$('.ipsK5S1').val(response.ipsK5S1)
				$('.ipsK5S2').val(response.ipsK5S2)
				$('.ipsK6S1').val(response.ipsK6S1)

				$('.sbdpK4S1').val(response.sbdpK4S1)
				$('.sbdpK4S2').val(response.sbdpK4S2)
				$('.sbdpK5S1').val(response.sbdpK5S1)
				$('.sbdpK5S2').val(response.sbdpK5S2)
				$('.sbdpK6S1').val(response.sbdpK6S1)

				$('.pjokK4S1').val(response.pjokK4S1)
				$('.pjokK4S2').val(response.pjokK4S2)
				$('.pjokK5S1').val(response.pjokK5S1)
				$('.pjokK5S2').val(response.pjokK5S2)
				$('.pjokK6S1').val(response.pjokK6S1)

				$('.sundaK4S1').val(response.sundaK4S1)
				$('.sundaK4S2').val(response.sundaK4S2)
				$('.sundaK5S1').val(response.sundaK5S1)
				$('.sundaK5S2').val(response.sundaK5S2)
				$('.sundaK6S1').val(response.sundaK6S1)
			},
			complete: function (xhr, status) {
			  $(".loading").css("top", "100%");
			  $(".gambar-loading").css("opacity", "0");
			},
			error: function (xhr, status, error) {
			  Swal.fire({
				icon: "error",
				title: 'Error',
				text: "Data gagal di muat status kode:"+error,
			  });
			},
		  });
		}

	
	
	// funtion roles Berkas
function rolesFormBerkas() {
	let roles = {
	  // start nilai
	  // PAI
	  paiK4S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  paiK4S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  paiK5S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  paiK5S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  paiK6S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  paiK6S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  // pkn
	  pknK4S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  pknK4S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  pknK5S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  pknK5S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  pknK6S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  pknK6S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  // indonesia
	  indoK4S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  indoK4S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  indoK5S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  indoK5S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  indoK6S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  indoK6S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  // mtk
  
	  mtkK4S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  mtkK4S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  mtkK5S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  mtkK5S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  mtkK6S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  mtkK6S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  // ipa
	  ipaK4S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  ipaK4S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  ipaK5S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  ipaK5S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  ipaK6S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  ipaK6S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  // ips
	  ipsK4S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  ipsK4S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  ipsK5S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  ipsK5S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  ipsK6S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  ipsK6S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  // sbdp
	  sbdpK4S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  sbdpK4S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  sbdpK5S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  sbdpK5S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  sbdpK6S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  sbdpK6S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  // pjok
	  pjokK4S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  pjokK4S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  pjokK5S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  pjokK5S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  pjokK6S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  pjokK6S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  // sunda
  
	  sundaK4S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  sundaK4S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  sundaK5S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  sundaK5S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  sundaK6S1: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
  
	  sundaK6S2: {
		required: true,
		rangelength: [2, 3],
		number: true,
		max: 100,
	  },
	  // end nilai
	  kk: {
		required: true,
		extension: "jpg|png|jpeg",
		maxgambar: 200000,
	  },
	  akte: {
		required: true,
		extension: "jpg|png|jpeg",
		maxgambar: 200000,
	  },
	  raport: {
		required: true,
		extension: "pdf",
		maxfile: 500000,
	  },
	  jalurPpdb: {
		required: true,
	  },
	  penyelengara: {
		required: true,
	  },
	  kategori_Kejuaraan: {
		required: true,
	  },
	  tingkat_kejuaraan: {
		required: true,
	  },
	  namaKejuaraan: {
		required: true,
	  },
	  namaAfirmasi: {
		required: true,
	  },
  
	  noKartu: {
		required: true,
	  },
	  namaPemilik: {
		required: true,
	  },
	  dtks: {
		required: true,
	  },
	};
  
	return roles;
  }

	
	//  function error form Berkas
function messageErrorBerkas() {
	let msg = {
	  // start Nilai
	  paiK4S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  paiK4S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  paiK5S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  paiK5S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  paiK6S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
  
	  paiK6S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  // pkn
	  pknK4S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  pknK4S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  pknK5S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  pknK5S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  pknK6S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
  
	  pknK6S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
  
	  // indo
	  indoK4S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
  
	  indoK4S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  indoK5S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  indoK5S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  indoK6S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  indoK6S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  // mtk
	  mtkK4S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  mtkK4S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  mtkK5S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  mtkK5S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  mtkK6S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  mtkK6S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  // ipa
	  ipaK4S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  ipaK4S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  ipaK5S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  ipaK5S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  ipaK6S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  ipaK6S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  // ips
	  ipsK4S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  ipsK4S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  ipsK5S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  ipsK5S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  ipsK6S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
  
	  ipsK6S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  // sbdp
	  sbdpK4S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
  
	  sbdpK4S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  sbdpK5S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  sbdpK5S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  sbdpK6S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
  
	  sbdpK6S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  // pjok
	  pjokK4S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  pjokK4S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  pjokK5S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  pjokK5S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  pjokK6S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  pjokK6S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  // sunda
	  sundaK4S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  sundaK4S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  sundaK5S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  sundaK5S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  sundaK6S1: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  sundaK6S2: {
		required: "Wajib diisi",
		rangelength: "min 2 max 3 digit",
		number: "Hanya Number",
		max: "max Nilai 100",
	  },
	  // end Nilai
	  kk: {
		required: "Berkas KK Belum di isi/ ulangi pilih berkas",
		extension: "Gunakan File jpg,png,jpeg",
		maxgambar: "Ukuran Gambar tidak lebih dari 200kb",
	  },
	  akte: {
		required: "Berkas akte Belum di isi / ulangi pilih berkas",
		extension: "Gunakan File jpg,png,jpeg",
		maxgambar: "Ukuran Gambar tidak lebih dari 200kb",
	  },
	  raport: {
		required: "Berkas Raport Belum di isi / ulangi pilih berkas",
		extension: "anda bukan upload file pdf",
		maxfile: "Ukuran File PDF tidak lebih dari 500kb",
	  },
	  noKartu: {
		required: "No Kartu Harus Diisi",
	  },
	  namaPemilik: {
		required: "Nama pemilik kartu harus di isi",
	  },
	  dtks: {
		required: "Nomor DTKS Sosial harus di isi",
	  },
	};
	return msg;
  }
  
		// akhir document ready function
})

function savePendaftran() {
	validForm = $('#form-3').valid();
	let action = $('#form-3').attr('action');

	if (validForm === true) {
		Swal.fire({
			title: "Kirim Data Pendaftaran?",
			text: "Data pendaftaran kan dikirim , dan tidak bisa di perbaiki lagi, anda yakin kirim pendaftaran?",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Ya Kirim Saja ",
		  }).then((result) => {
			if (result.value) {
			  $.ajax({
				url: action,
				data: $('#form-3').serialize(),
				type: 'POST',
				dataType: "json",
				success: function (response) {
				  if (response.pesan == "ok") {
					Swal.fire("Tersimpan!", "Data Pendaftaran tersimapan", "success");
					window.location.href = getURL() + "Akun";
				  } else if (response.pesan == "error") {
					Swal.fire(
					  "Gagal",
					  "Data Gagal Disimpan",
					  "error"
					);
					window.location.href = baseUrl() + "Akun";
				  }
				  },
				  error: function(xhr, status, error) {
					var err = eval("(" + xhr.responseText + ")");
					Swal.fire(
						"Gagal",
						`Response Server ${err.Message}`,
						"error"
					  );
				  }
			  });
			}
		  });
	} else {
		return false
	}
}



 

  

// data afirmasi



  