function getURL() {
  let url = $(".url").data("url");
  return url;
}

// ambil data flas message
// let flashdata = $(".data-flash").data("flash");
// if (flashdata) {
//   $(".modal-flash").modal("show");
// }

// untuk modal upload nilai
$(".custom-file-input").on("change", function () {
  let fileName = $(this).val().split("\\").pop();
  $(this).siblings(".custom-file-label").addClass("selected").html(fileName);
});

// // data tables upoad nilai
let tableUploadNilai = $("#tabelUploadNilai").DataTable({
  scrollY: "350px",
  scrollCollapse: true,
  paging: true,
  searching: true,
  processing: true,
  serverSide: true,
  bInfo: false,

  // Load data for the table's content from an Ajax source
  ajax: {
    url: getURL() + "Operator/get_dataNilai",
    type: "POST",
  },

  columnDefs: [
    {
      targets: [-1],
      orderable: false,
    },
  ],
});

// tabel zonasi
$("#tabelUploadPendaftaran").DataTable({
  scrollCollapse: true,
  paging: true,
  searching: true,
  bInfo: false,
  // columnDefs: [
  //   {
  //     targets: [0, 1, 2, 3, 4, 5, 6, -1],
  //     orderable: false,
  //   },
  // ],
});

// UNTUK GOOGLE MAPS
$("#longitude").focusout(function () {
  let longitude = $(this).val();
  let arrayLong = longitude.split(",");
  let lat = Number(arrayLong[0]);
  let lng = Number(arrayLong[1]);
  Swal.fire({
    icon: "success",
    title: "Longitude !!!",
    text: "Ditambahkan",
    timer: 2000,
  });

  initMap(lat, lng);
});

// mengambil longitude yang tersipan di user
function getLongitudeYangTersimpan() {
  $.ajax({
    url: getURL() + "Operator/getLongitudeByUser",
    type: "post",
    dataType: "json",
    success: function (response) {
      let lat;
      let lng;
      let arrayLong;
      if (response.longitude == null || response.longitude == "") {
        lat = -6.449570437616599;
        lng = 106.58742081021954;
      } else {
        arrayLong = response.longitude.split(",");
        lat = Number(arrayLong[0]);
        lng = Number(arrayLong[1]);
      }
      initMap(lat, lng);
    },
  });
}
// getLongitudeYangTersimpan();

// initMap(lat=0,lng=0);
function initMap(lat = 0, lng = 0) {
  let pesan;
  if (lat == 0 || lng == 0) {
    pesan = "Lokasi Belum Pilih";
    getLongitudeYangTersimpan();
  } else if (lat == -6.449570437616599 || lng == 106.58742081021954) {
    pesan = "Lokasi Belum Di pilih !";
  } else {
    pesan = "Lokasi Anda !";
  }
  const myLatlng = {
    lat: lat,
    lng: lng,
  };
  const map = new google.maps.Map(document.getElementById("map"), {
    zoom: 15,
    center: myLatlng,
  });
  // Create the initial InfoWindow.
  let infoWindow = new google.maps.InfoWindow({
    content: pesan,
    position: myLatlng,
  });

  var marker = new google.maps.Marker({
    position: myLatlng,
    map: map,
  });

  infoWindow.open(map, marker);
}

// mengambil data provinsi
// memilih data provinsi
$(".provinsi").on("change", function () {
  var url = $(".url").data("url");
  var id = $(this).val();
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $(".kota").html("");
  $.ajax({
    url: url + "Home/dataKota",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".kota").append(`	<option value="">Pilih Kota / Kabupaten</option>`);
      $.each(respon, function (i, v) {
        $(".kota").append(
          `
                    <option value="` +
            v.id +
            `">` +
            v.name +
            `</option>
                    `
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
});

// memilih data kota dan mengambila data kecamatan
$(".kota").on("change", function () {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  var url = $(".url").data("url");
  var id = $(this).val();
  $(".kecamatan").html("");
  $.ajax({
    url: url + "Home/dataKecamatan",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".kecamatan").append(`<option value="">Pilih Kecamatan</option>`);

      $.each(respon, function (i, v) {
        $(".kecamatan").append(
          `
                    <option value="` +
            v.id +
            `">` +
            v.name +
            `</option>
                    `
        );
        $(".loading").css("top", "100%");
        $(".gambar-loading").css("opacity", "0");
      });
    },
  });
});

// memilih data kecamatan untuk mengambil data desa
$(".kecamatan").on("change", function () {
  var url = $(".url").data("url");
  var id = $(this).val();
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $(".desa").html("");
  $.ajax({
    url: url + "Home/dataDesa",
    data: {
      id: id,
    },
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".desa").append(`	<option value="">Pilih Desa</option>`);
      $.each(respon, function (i, v) {
        $(".desa").append(
          `
                    <option value="` +
            v.id +
            `">` +
            v.name +
            `</option>
                    `
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
});

// validasi formulir biodata
$(".akun-container #formBiodata").validate({
  focusInvalid: true,
  invalidHandler: function (form, validator) {
    Swal.fire({
      icon: "error",
      title: "Belum lengkap !!!",
      text: "Cek kembali sebelum ke isian selanjutnya ",
      timer: 2000,
    });
    if (!validator.numberOfInvalids()) return;

    $("html, body").animate(
      {
        scrollTop: $(validator.errorList[0].element).offset().top - 190,
      },
      3000
    );
  },
  rules: rolesFormBiodata(),
  messages: messageErrorBiodata(),
  submitHandler: function (form) {
    Swal.fire({
      title: "Pesan",
      text: "Simpan Biodata ?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Ya",
    }).then((result) => {
      if (result.value) {
        $(".loading").css("top", "0");
        $(".gambar-loading").css("opacity", "1");
        $.ajax({
          url: getURL() + "Operator/SimpanBiodata",
          type: "post",
          dataType: "json",
          data: $(form).serialize(),
          success: function (response) {
            if (response.pesan == "ok") {
              window.location.href = getURL() + `Operator/Wali`;
            } else {
              window.location.href = getURL() + `Operator/Wali`;
            }
            $(".loading").css("top", "100%");
            $(".gambar-loading").css("opacity", "0");
          },
        });
      }
    });
  },
});
// akhir validasi formulir biodata

// validasi formulir Wali
$(".akun-container #formWali").validate({
  focusInvalid: true,
  invalidHandler: function (form, validator) {
    Swal.fire({
      icon: "error",
      title: "Belum lengkap !!!",
      text: "Cek kembali sebelum ke isian selanjutnya  ",
      timer: 2000,
    });
    if (!validator.numberOfInvalids()) return;

    $("html, body").animate(
      {
        scrollTop: $(validator.errorList[0].element).offset().top - 190,
      },
      3000
    );
  },
  rules: rolesFormWali(),
  messages: messageErrorWali(),
  submitHandler: function (form) {
    Swal.fire({
      title: "Pesan",
      text: "Simpan Data Orang Tua ?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Ya",
    }).then((result) => {
      if (result.value) {
        $(".loading").css("top", "0");
        $(".gambar-loading").css("opacity", "1");
        $.ajax({
          url: form.action,
          type: form.method,
          dataType: "json",
          data: $(form).serialize(),
          success: function (response) {
            if (response.pesan == "ok") {
              $(".loading").css("top", "100%");
              $(".gambar-loading").css("opacity", "0");
              window.location.href = getURL() + "Operator/formNilai";
            } else if (response.pesan == "gagal") {
              $(".loading").css("top", "100%");
              $(".gambar-loading").css("opacity", "0");
              window.location.href = getURL() + "Operator/formNilai";
            }
          },
        });
      }
    });
  },
});
// akhir validasi formulir Wali

// validasi formulir Nilai
$(".akun-container #formNilai").validate({
  focusInvalid: true,
  invalidHandler: function (form, validator) {
    Swal.fire({
      icon: "error",
      title: "Belum lengkap !!!",
      text: "Cek kembali sebelum ke isian selanjutnya  ",
      timer: 2000,
    });
    if (!validator.numberOfInvalids()) return;

    $("html, body").animate(
      {
        scrollTop: $(validator.errorList[0].element).offset().top - 190,
      },
      3000
    );
  },
  rules: rolesFormNilai(),
  messages: messageErrorNilai(),
  submitHandler: function (form) {
    Swal.fire({
      title: "Pesan",
      text: "Simpan Data Nilai ?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Ya",
    }).then((result) => {
      if (result.value) {
        $(".loading").css("top", "0");
        $(".gambar-loading").css("opacity", "1");
        $.ajax({
          url: form.action,
          type: form.method,
          dataType: "json",
          data: $(form).serialize(),
          success: function (response) {
            if (response.pesan == "ok") {
              $(".loading").css("top", "100%");
              $(".gambar-loading").css("opacity", "0");
              Swal.fire("Tersimpan!", "Data Nilai tersimapan", "success");
              window.location.href = getURL() + "Operator/formJalur";
            } else if (response.pesan == "gagal") {
              Swal.fire(
                "Tersimpan!",
                "Nilai di simpan, namun tidak ada prubahan data",
                "warning"
              );
              $(".loading").css("top", "100%");
              $(".gambar-loading").css("opacity", "0");
              window.location.href = getURL() + "Operator/formJalur";
            }
          },
        });
      }
    });
  },
});
// akhir validasi formulir nilai

// validasi formulir Berkas
$(".akun-container #formBerkas").validate({
  focusInvalid: true,
  invalidHandler: function (form, validator) {
    Swal.fire({
      icon: "error",
      title: "Belum lengkap !!!",
      text: "Cek kembali sebelum ke isian selanjutnya  ",
      timer: 2000,
    });
    if (!validator.numberOfInvalids()) return;

    $("html, body").animate(
      {
        scrollTop: $(validator.errorList[0].element).offset().top - 190,
      },
      3000
    );
  },
  rules: rolesFormBerkas(),
  messages: messageErrorBerkas(),
  submitHandler: function (form) {
    Swal.fire({
      title: "Kirim Data Pendaftaran?",
      text: "Data pendaftaran kan dikirim , dan tidak bisa di perbaiki lagi, anda yakin kirim pendaftaran?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Ya Kirim Saja ",
    }).then((result) => {
      if (result.value) {
        $.ajax({
          url: form.action,
          data: $(form).serialize(),
          type: form.method,
          dataType: "json",
          success: function (response) {
            if (response.pesan == "ok") {
              Swal.fire("Tersimpan!", "Data Nilai tersimapan", "success");
              window.location.href = getURL() + "Operator/Pendaftaran";
            } else if (response.pesan == "gagal") {
              Swal.fire(
                "Tersimpan!",
                "Nilai di simpan, namun tidak ada prubahan data",
                "warning"
              );
              window.location.href = getURL() + "Operator/Pendaftaran";
            }
          },
        });
      }
    });
  },
});

// ==================================================kumpulan roles form halaman Pendaftaran di operator====
// funtion roles biodata
function rolesFormBiodata() {
  let roles = {
    agama: {
      required: true,
    },
    anak_ke: {
      required: true,
    },
    nama: {
      required: true,
    },
    nik: {
      required: true,
      number: true,
      rangelength: [16, 16],
    },
    nisn: {
      rangelength: [10, 10],
      required: true,
      remote: function () {
        let checkit = {
          type: "POST",
          url: getURL() + "Operator/CekNisn",
          // contentType: "application/json; charset=utf-8",
          dataType: "json",
          data: {
            nisnsiswa: $("#nisn").val(),
          },
        };
        return checkit;
      },
    },
    email: {
      required: true,
      email:true,
      remote: function () {
        let checkit = {
          type: "POST",
          url: getURL() + "Operator/CekEmail",
          // contentType: "application/json; charset=utf-8",
          dataType: "json",
          data: {
            email: $("#email").val(),
          },
        };
        return checkit;
      },
    },
    tempatLahir: {
      required: true,
    },
    tglLahir: {
      required: true,
    },
    jk: {
      required: true,
    },
    noHp: {
      required: true,
      number: true,
      rangelength: [11, 13],
    },
    tinggiBadan: {
      required: true,
    },
    beratBadan: {
      required: true,
    },
    sekolahAsal: {
      required: true,
    },
    npsn: {
      required: true,
    },
    provinsi: {
      required: true,
    },
    kota: {
      required: true,
    },
    kk: {
      required: true,
      number: true,
      rangelength: [16, 16],
    },
    kecamatan: {
      required: true,
    },
    desa: {
      required: true,
    },
    rt: {
      required: true,
      rangelength: [1, 3],
    },
    rw: {
      required: true,
      rangelength: [1, 3],
    },
    kodePos: {
      required: true,
      rangelength: [1, 7],
    },
    alamat: {
      required: true,
    },
    longitude: {
      required: true,
      strongCoord: true,
    },
  };

  return roles;
}

// ========kumpulan message form di halaman opertaor===========================================
//  function error form biodata
function messageErrorBiodata() {
  let msg = {
    nama: {
      required: "Nama Pendaftar Harus Diisi",
    },
    nik: {
      required: "NIK Wajib diisi",
      number: "Hanya Angka Yg Di inpu",
      rangelength: "NIK harus 16 digit/angka",
    },
    nisn: {
      required: "NISN harus di isi",
      remote: "nisn sudah digunakan",
      rangelength: "nisn tidak kurang dan lebih dari 10 digit",
    },
    email: {
      required: "Email harus di isi",
      remote: 'Email sudah di gunakan',
      email:'Format Email Sudah Digunakan'
    },
    tempatLahir: {
      required: "tempat lahir harus disi",
    },
    tglLahir: {
      required: "Tanggal belum dipilih",
    },
    jk: {
      required: "Jenis kelamin belum di pilih",
    },
    noHp: {
      required: "No handphone harus diisi",
      number: "Input hanya angka",
      rangelength: "Min : 11  & max:13 digit",
    },
    tinggiBadan: {
      required: "tinggi badan harus disi",
    },
    beratBadan: {
      required: "Berat badan harus di isi",
    },
    sekolahAsal: {
      required: "Asal Sekolah Dasar Harus Diisi",
    },
    npsn: {
      required: "NPSN Sekolah Dasar Tidak Boleh Kosong",
    },
    kk: {
      required: "kaka Harus di isi",
      required: "KK Wajib diisi",
      number: "Hanya Angka Yg Di inpu",
      rangelength: "KK harus 16 digit/angka",
    },
    provinsi: {
      required: "Provinsi belum dipilih",
    },
    kota: {
      required: "Kota Belum Dipilih",
    },
    agama: {
      required: "Kolom isian agama belum di pilih",
    },
    anak_ke: {
      required: "Status anak ke- belum di pilih",
    },
    kecamatan: {
      required: "Kecamatan belum dipilih",
    },
    desa: {
      required: "desa belum dipilih",
    },
    rt: {
      required: "Rt Harus Diisi",
      rangelength: "Max 3 Digit",
    },
    rw: {
      required: "rw harus diisi",
      rangelength: "Max 3 Digit",
    },
    kodePos: {
      required: "Kode Pos harus disi",
      rangelength: "Max 7 Digit",
    },
    alamat: {
      required: "Alamat masih kosong",
    },
    longitude: {
      required: "Longitude Wajib Di isi",
    },
  };
  return msg;
}

// funtion roles Wali
function rolesFormWali() {
  let roles = {
    ayah: {
      required: true,
    },
    nikAyah: {
      required: true,
      number: true,
      rangelength: [16, 16],
    },
    tanggalLahirAyah: {
      required: true,
    },
    pendidikanAyah: {
      required: true,
    },
    pekerjaanAyah: {
      required: true,
    },
    penghasilanAyah: {
      required: true,
    },
    //  ibu
    ibu: {
      required: true,
    },
    nikIbu: {
      required: true,
      number: true,
      rangelength: [16, 16],
    },
    tanggalLahirIbu: {
      required: true,
    },
    pendidikanIbu: {
      required: true,
    },
    pekerjaanIbu: {
      required: true,
    },
    penghasilanIbu: {
      required: true,
    },
    notelepon: {
      required: true,
      number: true,
      rangelength: [11, 13],
    },
  };

  return roles;
}

//  function error form Wali
function messageErrorWali() {
  let msg = {
    ayah: {
      required: "Nama Ayah wajib diisi (meninggal: ketik Alm.sebelum nama)",
    },
    nikAyah: {
      required: "Nik ayah harus di isi",
      number: "nik harus number",
      rangelength: "NIK tidak kurang/lebih 16 digit",
    },
    tanggalLahirAyah: {
      required: "silahkan pilih tanggal lahir",
    },
    pendidikanAyah: {
      required: "pendidikan belum dipilih",
    },
    pekerjaanAyah: {
      required: "pekerjaan belum dipilih",
    },
    penghasilanAyah: {
      required: "penghasilan belum dipilih",
    },
    //  ibu
    ibu: {
      required: "Nama Ibu wajib diisi (meninggal: ketik Almh.sebelum nama)",
    },
    nikIbu: {
      required: "nik masih kosong",
      number: "nik harus number",
      rangelength: "nik tidak kurang/lebih 16 digit",
    },
    tanggalLahirIbu: {
      required: "tanggal lahir belum dipilih",
    },
    pendidikanIbu: {
      required: "pendidikan ibu belum dipilih",
    },
    pekerjaanIbu: {
      required: "pekerjaan belum dipilih",
    },
    penghasilanIbu: {
      required: "penghasilan belum dipilih",
    },
    notelepon: {
      required: "No telepon masih kosong",
      number: "No telepon harus number",
      rangelength: "Telapon tidak kurang 11 & lebih 13 digit",
    },
  };
  return msg;
}

// funtion roles Nilai
function rolesFormNilai() {
  let roles = {
    // PAI
    paiK4S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    paiK4S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    paiK5S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    paiK5S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    paiK6S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    paiK6S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    // pkn
    pknK4S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    pknK4S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    pknK5S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    pknK5S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    pknK6S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    pknK6S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    // indonesia
    indoK4S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    indoK4S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    indoK5S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    indoK5S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    indoK6S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    indoK6S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    // mtk

    mtkK4S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    mtkK4S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    mtkK5S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    mtkK5S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    mtkK6S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    mtkK6S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    // ipa
    ipaK4S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    ipaK4S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    ipaK5S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    ipaK5S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    ipaK6S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    ipaK6S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    // ips
    ipsK4S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    ipsK4S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    ipsK5S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    ipsK5S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    ipsK6S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    ipsK6S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    // sbdp
    sbdpK4S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    sbdpK4S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    sbdpK5S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    sbdpK5S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    sbdpK6S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    sbdpK6S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    // pjok
    pjokK4S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    pjokK4S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    pjokK5S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    pjokK5S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    pjokK6S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    pjokK6S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    // sunda

    sundaK4S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    sundaK4S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    sundaK5S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    sundaK5S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
    sundaK6S1: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },

    sundaK6S2: {
      required: true,
      rangelength: [2, 3],
      number: true,
      max: 100,
    },
  };

  return roles;
}

//  function error form Nilai
function messageErrorNilai() {
  let msg = {
    paiK4S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    paiK4S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    paiK5S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    paiK5S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    paiK6S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },

    paiK6S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    // pkn
    pknK4S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    pknK4S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    pknK5S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    pknK5S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    pknK6S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },

    pknK6S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },

    // indo
    indoK4S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },

    indoK4S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    indoK5S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    indoK5S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    indoK6S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    indoK6S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    // mtk
    mtkK4S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    mtkK4S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    mtkK5S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    mtkK5S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    mtkK6S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    mtkK6S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    // ipa
    ipaK4S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    ipaK4S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    ipaK5S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    ipaK5S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    ipaK6S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    ipaK6S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    // ips
    ipsK4S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    ipsK4S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    ipsK5S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    ipsK5S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    ipsK6S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },

    ipsK6S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    // sbdp
    sbdpK4S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },

    sbdpK4S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    sbdpK5S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    sbdpK5S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    sbdpK6S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },

    sbdpK6S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    // pjok
    pjokK4S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    pjokK4S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    pjokK5S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    pjokK5S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    pjokK6S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    pjokK6S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    // sunda
    sundaK4S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    sundaK4S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    sundaK5S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    sundaK5S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    sundaK6S1: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
    sundaK6S2: {
      required: "Wajib diisi",
      rangelength: "min 2 max 3 digit",
      number: "Hanya Number",
      max: "max Nilai 100",
    },
  };
  return msg;
}

// funtion roles Berkas
function rolesFormBerkas() {
  let roles = {
    jalurPpdb: {
      required: true,
    },
    penyelengara: {
      required: true,
    },
    kategori: {
      required: true,
    },
    tingkatPrestasi: {
      required: true,
    },
    namaKejuaraan: {
      required: true,
    },
    namaAfrimasi: {
      required: true,
    },

    noKartu: {
      required: true,
    },
  };

  return roles;
}

//  function error form Berkas
function messageErrorBerkas() {
  let msg = {
    noKartu: {
      required: "No Kartu Harus Diisi",
    },
    jalurPpdb: {
      required: "Pilih Jalur ppdb",
    },
  };
  return msg;
}

// method custum untuk form biodata longitude

$.validator.addMethod(
  "strongCoord",
  function (value, element) {
    return (
      this.optional(element) ||
      (value.length >= 4 && /^(-?\d+(\.\d+)?),\s*(-?\d+(\.\d+)?)$/.test(value))
    );
  },
  "Longitude tidak valid'."
);

// date piker siswa
$("#tglLahir").datepicker({
  altField: "#actualDate",
  defaultDate: "01-06-2008",
  dateFormat: "dd-mm-yy",
  dayNames: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
  dayNamesMin: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
  duration: "slow",
  minDate: new Date('2008', '01', '01'),
  changeYear: true,
  yearRange: "2008:2015",
  changeMonth: true,
});

// datepiker ayah
$("#tanggalLahirAyah").datepicker({
  altField: "#actualDate",
  defaultDate: "01-06-1945",
  dateFormat: "dd-mm-yy",
  dayNames: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
  dayNamesMin: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
  duration: "slow",
  changeYear: true,
  yearRange: "1945:2020",
});

$(function () {
  $("#tglLahir").datepicker();
  $(".ui-datepicker").addClass("notranslate");
});

// datepiker Ibu
$("#tanggalLahirIbu").datepicker({
  altField: "#actualDate",
  defaultDate: "01-06-1945",
  dateFormat: "dd-mm-yy",
  dayNames: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
  dayNamesMin: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
  duration: "slow",
  changeYear: true,
  yearRange: "1945:2020",
});

// function jalur afirmasi
function afirmasi() {
  dataAfirmasi();
  $(".konten-syarat").append(`
		<div class="row my-3">
			<div class="col my3">
				<label for="namaAfrimasi">Pilih Nama Afirmasi</label>
				<select name="namaAfrimasi" id="namaAfrimasi" class="namaAfrimasi form-control form-control-sm">
				</select>
			</div>
		</div>
		`);
}

// memilih jenis Afirmasi
$(".konten-syarat").on("change", ".namaAfrimasi", function () {
  $(".konten-syarat2").html("");
  var id = $(this).val();
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: getURL() + "Operator/getAfirmasiById",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      if (respon == null) {
        $(".konten-syarat2").append(`
						<div class="row my-3">
							<div class="col-6 col-lg-6">
								<p class="text-warning">Silahkan pilih jenis afirmasi</p>
							</div>
						</div>
							
						`);
      } else if (respon.id == 5) {
        $(".konten-syarat2").append("");
      } else {
        $(".konten-syarat2").append(
          `
						<div class="row my-3">
							<div class="col-6 col-lg-6">
								<label for="namaPemilik">Nama Sesuai di Kartu ` +
            respon.nama_jenis_afirmasi +
            `</label>
								<input type="text" class="form-control" name="namaPemilik" id="namaPemilik">
							</div>
							<div class="col-6 col-lg-6">
								<label for="noKartu">No Kartu ` +
            respon.nama_jenis_afirmasi +
            `</label>
								<input type="text" class="form-control" name="noKartu" id="noKartu">
							</div>
						</div>
						<div class="row my-3">
							<div class="col-6 col-lg-6">
								<label for="dtks">No ID DTKS DINSOS</label>
								<input type="text" class="form-control" name="dtks" id="dtks">
							</div>
						</div>
							
						`
        );
      }

      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
});

// load jenis afirmasi]
function dataAfirmasi() {
  $(".konten-syarat .namaAfrimasi").html("");
  $.ajax({
    url: getURL() + "Operator/jenisAfirmasi",
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".konten-syarat .namaAfrimasi").append(
        `<option value="">Nama Afrimasi---</option>`
      );
      $.each(respon, function (i, v) {
        $(".konten-syarat .namaAfrimasi").append(
          `
					<option value="` +
            v.id +
            `">` +
            v.nama_jenis_afirmasi +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// ================================Prestasi Kejuaraan
function prestasi() {
  dataPenyelengara();
  $(".konten-syarat").append(`
		<div class="row my-3">
			<div class="col my3">
				<label for="penyelengara">Pilih Penyelengara</label>
				<select name="penyelengara" id="penyelengara" class="penyelengara form-control form-control-sm">
					
				</select>
			</div>
		</div>
		`);
}

function dataPenyelengara() {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: getURL() + "Operator/penyelengara",
    dataType: "json",
    method: "post",
    success: function (respon) {
      $(".konten-syarat .penyelengara").append(
        `<option value="">Peyelengara---</option>`
      );
      $.each(respon, function (i, v) {
        $(".konten-syarat .penyelengara").append(
          `
				<option value="` +
            v.id_penyelengara +
            `">` +
            v.peyelengara +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// memilih penyelengara dan menampilkan kategori kejuaraan
$(".konten-syarat").on("change", ".penyelengara", function () {
  $(".konten-syarat2").html("");
  $(".konten-syarat3").html("");
  var id = $(this).val();
  // loadKategoriKejuaraan(id);
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $(".konten-syarat2").append(`
				<div class="row my-3 .kategori-row">
					<div class="col my3">
						<label for="kategori">Pilih kategori</label>
						<select name="kategori" id="kategori" class="kategori form-control form-control-sm">
							
						</select>
					</div>
				</div>
		`);
  $(".loading").css("top", "100%");
  $(".gambar-loading").css("opacity", "0");
});

// ambil data kategori kejuaraan berdasarkan peyelengara
function loadKategoriKejuaraan(id) {
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $.ajax({
    url: getURL() + "Operator/KategoriKejuaraan",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      $(".konten-syarat2 .kategori").append(
        `<option value="">Kategori---</option>`
      );
      $.each(respon, function (i, v) {
        $(".konten-syarat2 .kategori").append(
          `
					<option value="` +
            v.id_satuan +
            `">` +
            v.satuan +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// memilih tingkat prestasi berdasarkan kategori
$(".konten-syarat2").on("change", ".kategori", function () {
  $(".konten-syarat3").html("");
  var id = $(this).val();
  // loadTingkatPrestasi(id);
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $(".konten-syarat3").append(`
				<div class="row my-3">
					<div class="col my3">
						<label for="tingkatPrestasi">Pilih Tingkat Prestasi</label>
						<select name="tingkatPrestasi" id="tingkatPrestasi" class="tingkatPrestasi form-control form-control-sm">
							
						</select>
					</div>
				</div>
		`);
  $(".loading").css("top", "100%");
  $(".gambar-loading").css("opacity", "0");
});

// load data tingkat prestasi
function loadTingkatPrestasi(id) {
  $.ajax({
    url: getURL() + "Operator/tingkatPrestasi",
    dataType: "json",
    method: "post",
    data: {
      id: id,
    },
    success: function (respon) {
      $(".konten-syarat3 .tingkatPrestasi").append(
        `<option value="">tingkatPrestasi---</option>`
      );
      $.each(respon, function (i, v) {
        $(".konten-syarat3 .tingkatPrestasi").append(
          `
					<option value="` +
            v.id +
            `">` +
            v.kejuaraan +
            `</option>
				`
        );
      });
      $(".loading").css("top", "100%");
      $(".gambar-loading").css("opacity", "0");
    },
  });
}

// menampilkan nama kejuaraan berdsarkan tingkat prestasi
$(".konten-syarat3").on("change", ".tingkatPrestasi", function () {
  $(".konten-syarat4").html("");
  // dragGambar();
  // loadTingkatPrestasi(id)
  $(".loading").css("top", "0");
  $(".gambar-loading").css("opacity", "1");
  $(".konten-syarat4").append(`
				<div class="row my-3">
					<div class="col my3">
					<label for="notelepon">Nama Kejuaran</label>
						<input type="text" class="form-control form-control-custum" name="namaKejuaraan" id="namaKejuaraan">
					</div>
				</div>
			`);
  $(".loading").css("top", "100%");
  $(".gambar-loading").css("opacity", "0");
});

$(".loading").css("top", "100%");
$(".gambar-loading").css("opacity", "0");
